/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.util;

public class BitUtil {
    public static int[] getBitByte(byte b) {
        int[] bits = new int[8];
        for (int i = 0; i < 8; ++i) {
            int n = 1 << 7 - i;
            int result = b & n;
            bits[i] = result == n ? 1 : 0;
        }
        return bits;
    }

    public static int[] getBitBytes(byte[] bytes) {
        int[] bits = new int[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            int[] aBits = BitUtil.getBitByte(bytes[i]);
            System.arraycopy(aBits, 0, bits, i * 8, aBits.length);
        }
        return bits;
    }

    public static int getBitValue(int[] bits, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("startIndex\u548cendIndex\u5fc5\u987b\u5927\u4e8e0!");
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8eend!");
        }
        if (startIndex == endIndex) {
            return bits[startIndex];
        }
        int v = 0;
        int length = endIndex - startIndex;
        for (int i = startIndex; i <= endIndex; ++i) {
            v |= bits[i] << length - (i - startIndex);
        }
        if (v > 1 << length + 1) {
            StringBuilder builder = new StringBuilder();
            for (int b : bits) {
                builder.append(b);
            }
            throw new IllegalArgumentException("\u6570\u636e\u89e3\u6790\u5931\u8d25!\u5f53\u524d\u8ba1\u7b97\u503c:" + v + ",\u5f53\u524d\u6570\u7ec4:" + builder.toString() + ",\u5f00\u59cb\u7d22\u5f15:" + startIndex + ",\u7ed3\u675f\u7d22\u5f15:" + endIndex);
        }
        return v;
    }

    public static byte[] bits2Bytes(int[] bits) {
        if (bits.length % 8 != 0) {
            throw new IllegalArgumentException("bit\u6570\u7ec4\u7684\u957f\u5ea6\u5fc5\u987b\u4e3a8\u7684\u500d\u6570!");
        }
        byte[] bytes = new byte[bits.length / 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = 0;
            for (int j = 0; j < 8; ++j) {
                if (bits[i * 8 + j] != 1) continue;
                b = (byte)(b & 0xFF | 1 << 7 - j);
            }
            bytes[i] = b;
        }
        return bytes;
    }

    public static void setBitValue(int[] bits, int startIndex, int endIndex, int value) {
        if (startIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("startIndex\u548cendIndex\u5fc5\u987b\u5927\u4e8e0!startIndex:" + startIndex + ",endIndex:" + endIndex);
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8eend!startIndex:" + startIndex + ",endIndex:" + endIndex);
        }
        int maxValue = 1 << endIndex - startIndex + 1;
        if (value >= maxValue) {
            throw new IllegalArgumentException("value\u503c\u5fc5\u987b\u5c0f\u4e8e\u6307\u5b9a\u4f4d\u6570\u957f\u5ea6!\u5f53\u524dvalue\u503c:" + value + ",\u5141\u8bb8\u7684\u6700\u5927\u503c:" + maxValue);
        }
        if (startIndex == endIndex) {
            bits[startIndex] = value;
        }
        int length = endIndex - startIndex;
        for (int i = startIndex; i <= endIndex; ++i) {
            int a = value & 1 << length - (i - startIndex);
            if (a == 0) continue;
            bits[i] = (a & a - 1) == 0 ? 1 : 0;
        }
    }
}

