/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.server;

import cn.schoolwow.quickserver.controller.ExceptionHandler;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.ResponseBodyAdvice;
import cn.schoolwow.quickserver.controller.annotation.CrossOrigin;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.ControllerMeta;
import cn.schoolwow.quickserver.domain.HttpSessionMeta;
import cn.schoolwow.quickserver.domain.ServerConfigMeta;
import cn.schoolwow.quickserver.server.HttpClientThread;
import cn.schoolwow.quickserver.websocket.ServerEndpoint;
import cn.schoolwow.quickserver.websocket.WebSocketServerListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class HttpServer {
    Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private ServerConfigMeta serverConfigMeta;

    public HttpServer(ServerConfigMeta serverConfigMeta) {
        this.serverConfigMeta = serverConfigMeta;
    }

    public void start() throws IOException {
        this.registerController();
        this.registerWebsocket();
        this.startKeepAliveScheduleTask();
        this.startHttpSessionScheduleTask();
        ServerSocket serverSocket = new ServerSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.serverConfigMeta.port);
        serverSocket.bind(inetSocketAddress);
        this.logger.info("\u670d\u52a1\u5668\u542f\u52a8:{}", (Object)inetSocketAddress);
        while (true) {
            Socket socket = serverSocket.accept();
            this.logger.debug("\u63a5\u6536\u5ba2\u6237\u7aefSocket\u94fe\u63a5:{}", (Object)socket);
            this.serverConfigMeta.threadPoolExecutor.execute(new HttpClientThread(socket, this.serverConfigMeta));
        }
    }

    private void registerController() {
        String[] beanNames;
        this.serverConfigMeta.applicationContext.refresh();
        for (String beanName : beanNames = this.serverConfigMeta.applicationContext.getBeanNamesForAnnotation(RestController.class)) {
            Method[] methods;
            Object instance = this.serverConfigMeta.applicationContext.getBean(beanName);
            String bathUrl = "";
            RequestMapping classRequestMapping = instance.getClass().getDeclaredAnnotation(RequestMapping.class);
            if (classRequestMapping != null) {
                bathUrl = classRequestMapping.value();
            }
            for (Method method : methods = instance.getClass().getMethods()) {
                RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
                if (methodRequestMapping == null) continue;
                ControllerMeta controllerMeta = new ControllerMeta();
                controllerMeta.instance = instance;
                controllerMeta.mappingUrl = bathUrl + methodRequestMapping.value();
                controllerMeta.requestMethodList.addAll(Arrays.asList(methodRequestMapping.method()));
                if (null != method.getAnnotation(CrossOrigin.class) || null != method.getDeclaringClass().getAnnotation(CrossOrigin.class)) {
                    controllerMeta.requestMethodList.add(RequestMethod.OPTIONS);
                }
                controllerMeta.antPatternUrl = controllerMeta.mappingUrl.replaceAll("\\{\\w+\\}", "\\*");
                controllerMeta.method = method;
                this.serverConfigMeta.controllerMetaList.add(controllerMeta);
                this.logger.info("\u6620\u5c04\u8def\u5f84 [{},method={}] onto {}", new Object[]{controllerMeta.mappingUrl, controllerMeta.requestMethodList, method});
            }
        }
        try {
            this.serverConfigMeta.responseBodyAdvice = (ResponseBodyAdvice)this.serverConfigMeta.applicationContext.getBean(ResponseBodyAdvice.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.serverConfigMeta.exceptionHandler = (ExceptionHandler)this.serverConfigMeta.applicationContext.getBean(ExceptionHandler.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private void registerWebsocket() {
        String[] beanNames;
        for (String beanName : beanNames = this.serverConfigMeta.applicationContext.getBeanNamesForType(WebSocketServerListener.class)) {
            WebSocketServerListener webSocketServerListener = (WebSocketServerListener)this.serverConfigMeta.applicationContext.getBean(beanName);
            ServerEndpoint serverEndpoint = webSocketServerListener.getClass().getAnnotation(ServerEndpoint.class);
            if (null == serverEndpoint) {
                throw new IllegalArgumentException("WebSocket\u7c7b\u672a\u6307\u5b9a\u8def\u5f84!\u8bf7\u4f7f\u7528serverEndpoint\u6ce8\u518c\u6307\u5b9a\u8def\u5f84!\u7c7b\u540d:" + webSocketServerListener.getClass().getName());
            }
            this.logger.info("\u6620\u5c04WebSocket [{}] onto {}", (Object)serverEndpoint.value(), (Object)webSocketServerListener.getClass().getName());
            this.serverConfigMeta.uriWebSocketServerListenerMap.put(serverEndpoint.value(), webSocketServerListener);
        }
    }

    private void startHttpSessionScheduleTask() {
        this.serverConfigMeta.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            Set<Map.Entry<String, HttpSessionMeta>> entrySet = this.serverConfigMeta.sessionMap.entrySet();
            entrySet.removeIf(entry -> (System.currentTimeMillis() - ((HttpSessionMeta)entry.getValue()).lastAccessedTime) / 1000L >= (long)this.serverConfigMeta.sessionTimeout);
        }, 60L, 600L, TimeUnit.SECONDS);
    }

    private void startKeepAliveScheduleTask() {
        if (!this.serverConfigMeta.keepAlive) {
            return;
        }
        this.serverConfigMeta.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            this.logger.trace("\u5f00\u59cb\u8fdb\u884ckeepAlive\u5b9a\u65f6\u68c0\u67e5\u4efb\u52a1");
            List<Client> list = this.serverConfigMeta.keepAliveClientList;
            synchronized (list) {
                Iterator<Client> clientIterator = this.serverConfigMeta.keepAliveClientList.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (client.socket.isClosed()) {
                        this.logger.debug("\u5ba2\u6237\u7aef\u94fe\u63a5\u5df2\u7ecf\u5173\u95ed,\u4ece\u7f13\u5b58\u4e2d\u79fb\u9664!\u5ba2\u6237\u7aef:{}", (Object)client.socket);
                        clientIterator.remove();
                        continue;
                    }
                    this.logger.trace("\u68c0\u67e5\u8d85\u65f6\u65f6\u95f4.\u5ba2\u6237\u7aef\u4e0a\u6b21\u6d3b\u8dc3\u65f6\u95f4:{},\u5957\u63a5\u5b57:{}", (Object)new Date(client.lastActiveTime), (Object)client.socket);
                    if (System.currentTimeMillis() - client.lastActiveTime < (long)this.serverConfigMeta.keepAliveTimeout) continue;
                    this.logger.debug("\u5173\u95ed\u4e0d\u6d3b\u8dc3\u5ba2\u6237\u7aef,\u5957\u63a5\u5b57:{}", (Object)new Date(client.lastActiveTime), (Object)client.socket);
                    clientIterator.remove();
                    try {
                        client.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 3000L, this.serverConfigMeta.keepAliveTimeout / 2, TimeUnit.MILLISECONDS);
    }
}

