/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.response;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedLimitOutputStream
extends OutputStream {
    private Logger logger = LoggerFactory.getLogger(SpeedLimitOutputStream.class);
    private volatile long bytesPerSecond;
    private volatile long totalSendBytes;
    private volatile long lastSendBytes;
    private volatile long lastRecordTime = System.nanoTime();
    private OutputStream outputStream;

    public SpeedLimitOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public synchronized void setMaxDownloadSpeed(int setMaxDownloadSpeed) {
        this.bytesPerSecond = setMaxDownloadSpeed * 1024;
    }

    public synchronized void limit(int length) {
        this.totalSendBytes += (long)length;
        while (this.bytesPerSecond > 0L && this.totalSendBytes - this.lastSendBytes > this.bytesPerSecond) {
            long waitNanoTime = 1000000000L - (System.nanoTime() - this.lastRecordTime);
            if (waitNanoTime > 0L) {
                try {
                    Thread.sleep(waitNanoTime / 1000000L, (int)(waitNanoTime % 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.lastRecordTime = System.nanoTime();
            this.lastSendBytes += this.bytesPerSecond;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.limit(1);
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.limit(len);
        this.outputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b.length > 0) {
            this.limit(b.length);
        }
        this.outputStream.write(b);
    }
}

