/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.response;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.response.EventSource;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.response.HttpStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseImpl
implements HttpResponse {
    private Logger logger = LoggerFactory.getLogger(HttpResponseImpl.class);
    private Client client;

    public HttpResponseImpl(Client client) {
        this.client = client;
    }

    @Override
    public void status(HttpStatus httpStatus) {
        this.client.httpResponse.httpStatus(httpStatus);
    }

    @Override
    public void charset(String charset) {
        this.client.httpResponseMeta.charset = charset;
    }

    @Override
    public void addCookie(HttpCookie httpCookie) {
        StringBuilder builder = new StringBuilder(httpCookie.getName() + "=" + httpCookie.getValue() + ";");
        if (httpCookie.getMaxAge() > 0L) {
            String expires = LocalDateTime.now().plusSeconds(httpCookie.getMaxAge()).format(DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US));
            builder.append(" expires=" + expires + ";");
        }
        if (null != httpCookie.getDomain()) {
            builder.append(" domain=" + httpCookie.getDomain() + ";");
        }
        if (null != httpCookie.getPath()) {
            builder.append(" path=" + httpCookie.getPath() + ";");
        }
        if (!this.client.httpResponseMeta.headers.containsKey("Set-Cookie")) {
            this.client.httpResponseMeta.headers.put("Set-Cookie", new ArrayList());
        }
        this.client.httpResponseMeta.headers.get("Set-Cookie").add(builder.toString());
    }

    @Override
    public List<String> getHeader(String name) {
        return this.client.httpResponseMeta.headers.get(name);
    }

    @Override
    public void addHeader(String name, String value) {
        if (!this.client.httpResponseMeta.headers.containsKey(name)) {
            this.client.httpResponseMeta.headers.put(name, new ArrayList());
        }
        this.client.httpResponseMeta.headers.get(name).add(value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.client.httpResponseMeta.headers.put(name, new ArrayList<String>(Arrays.asList(value)));
    }

    @Override
    public String getCharset() {
        return this.client.httpResponseMeta.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.client.httpResponseMeta.charset = charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.client.httpResponseMeta.charset = charset.name();
    }

    @Override
    public void setContentLength(long contentLength) {
        this.client.httpResponseMeta.contentLength = contentLength;
    }

    @Override
    public String getContentType() {
        return this.client.httpResponseMeta.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.client.httpResponseMeta.contentType = contentType;
    }

    @Override
    public String getContentDisposition() {
        List<String> values = this.getHeader("Content-Disposition");
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    @Override
    public void setContentDisposition(String fileName) {
        try {
            String contentDisposition = "attachment;filename*=utf-8''" + new String(fileName.getBytes(), this.client.httpResponseMeta.charset);
            this.setHeader("Content-Disposition", contentDisposition);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void acceptRanges(boolean acceptRanges) {
        if (acceptRanges) {
            this.setHeader("Accept-Ranges", "bytes");
        } else {
            this.client.httpResponseMeta.headers.remove("Accept-Ranges");
        }
    }

    @Override
    public void redirect(String url) {
        this.client.httpResponse.httpStatus(HttpStatus.FOUND);
        this.client.httpResponseMeta.headers.put("Location", Arrays.asList(url));
    }

    @Override
    public void streamingBody(String data) throws IOException {
        if (null == this.client.httpResponseMeta.headerString) {
            this.setContentType("text/plain");
            this.setCharset(this.client.httpResponseMeta.charset);
            this.setHeader("Access-Control-Allow-Origin", "*");
            this.client.httpResponse.fillHeadStream();
        }
        this.client.httpResponseMeta.outputStream.write(data.getBytes(this.client.httpResponseMeta.charset));
        this.client.httpResponseMeta.outputStream.flush();
    }

    @Override
    public void streamingBodyLine(String data) throws IOException {
        this.streamingBody(data + "\n");
    }

    @Override
    public void eventSource(EventSource eventSource) throws IOException {
        if (null == this.client.httpResponseMeta.headerString) {
            this.setContentType("text/event-stream");
            this.setCharset("utf-8");
            this.client.httpResponse.fillHeadStream();
        }
        String body = "id:" + eventSource.id + "\r\nevent:" + eventSource.event + "\r\nretry:" + eventSource.retry + "\r\ndata:" + eventSource.data + "\r\n\r\n";
        this.client.httpResponseMeta.outputStream.write(body.getBytes(this.client.httpResponseMeta.charset));
        this.client.httpResponseMeta.outputStream.flush();
    }

    @Override
    public void download(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728!" + filePath);
        }
        this.setContentLength(Files.size(path));
        this.setCharset("utf-8");
        this.setContentDisposition(path.toFile().getName());
        OutputStream outputStream = this.getOutputStream();
        byte[] content = Files.readAllBytes(path);
        outputStream.write(content);
        outputStream.flush();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (null == this.client.httpResponseMeta.headerString) {
            this.client.httpResponse.fillHeadStream();
        }
        return this.client.httpResponseMeta.outputStream;
    }

    public void httpStatus(HttpStatus httpStatus) {
        this.client.httpResponseMeta.status = httpStatus.status;
        this.client.httpResponseMeta.statusMessage = httpStatus.statusMessage;
    }

    public void fillHeadStream() throws IOException {
        if (this.client.httpResponseMeta.status == 0) {
            this.client.httpResponse.httpStatus(HttpStatus.OK);
        }
        this.client.httpResponseMeta.headers.put("Content-Type", Arrays.asList(this.client.httpResponseMeta.contentType));
        if (this.client.httpResponseMeta.contentLength > 0L) {
            this.client.httpResponseMeta.headers.put("Content-Length", Arrays.asList(this.client.httpResponseMeta.contentLength + ""));
        }
        if (null == this.client.httpResponseMeta.headerString) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.client.httpResponseMeta.protocol + " " + this.client.httpResponseMeta.status + " " + this.client.httpResponseMeta.statusMessage + "\r\n");
            Set<Map.Entry<String, List<String>>> entrySet = this.client.httpResponseMeta.headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                for (String value : entry.getValue()) {
                    builder.append(entry.getKey() + ": " + value + "\r\n");
                }
            }
            builder.append("\r\n");
            this.client.httpResponseMeta.headerString = builder.toString();
            this.client.httpResponseMeta.outputStream.write(this.client.httpResponseMeta.headerString.getBytes(this.client.httpResponseMeta.charset));
            this.client.httpResponseMeta.outputStream.flush();
        } else {
            this.logger.warn("\u5934\u90e8\u62a5\u6587\u5df2\u5199\u5165");
        }
    }
}

