/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.exception.HttpStatusException;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.response.HttpStatus;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import cn.schoolwow.quickserver.websocket.WebSocketSessionImpl;
import cn.schoolwow.quickserver.websocket.domain.OPCode;
import cn.schoolwow.quickserver.websocket.domain.WebSocketFrame;
import cn.schoolwow.quickserver.websocket.stream.WebSocketFrameStream;
import cn.schoolwow.quickserver.websocket.stream.WebSocketFrameStreamImpl;
import cn.schoolwow.quickserver.websocket.stream.WebSocketStream;
import cn.schoolwow.quickserver.websocket.stream.WebSocketStreamImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(WebSocketHandler.class);
    private WebSocketFrameStream webSocketFrameStream;

    @Override
    public Handler handle(Client client) throws Exception {
        WebSocketStreamImpl webSocketStream = new WebSocketStreamImpl(client.socket);
        this.webSocketFrameStream = new WebSocketFrameStreamImpl(webSocketStream);
        try {
            this.upgrade(client);
        }
        catch (HttpStatusException e) {
            this.logger.error("websocket\u63e1\u624b\u5931\u8d25", (Throwable)e);
            this.sendHandshakeFailureResponse(e);
            return null;
        }
        this.handleWebSocketFrame(client);
        return null;
    }

    private void upgrade(Client client) throws IOException {
        this.checkRequestLine(client);
        String secWebSocketKey = this.checkRequestHeader(client);
        String secWebSocketAccept = null;
        try {
            secWebSocketAccept = QuickServerUtil.calculateSecWebSocketAccept(secWebSocketKey);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("\u670d\u52a1\u7aef\u9519\u8bef", (Throwable)e);
            throw new HttpStatusException(500, "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef!");
        }
        this.logger.trace("\u8ba1\u7b97Sec-WebSocket-Accept\u5934\u90e8\u7684\u503c,\u8bf7\u6c42\u5934Sec-Web-Socket-Key:{},\u54cd\u5e94\u5934Sec-WebSocket-Accept:{}", (Object)secWebSocketKey, (Object)secWebSocketAccept);
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append("HTTP/1.1 101 Web Socket Protocol Handshake\r\n");
        responseBuilder.append("Upgrade: websocket\r\n");
        responseBuilder.append("Connection: Upgrade\r\n");
        responseBuilder.append("Sec-WebSocket-Accept: " + secWebSocketAccept + "\r\n");
        responseBuilder.append("\r\n");
        WebSocketStream webSocketStream = this.webSocketFrameStream.getWebSocketStream();
        webSocketStream.write(responseBuilder.toString().getBytes(StandardCharsets.UTF_8));
        webSocketStream.flush();
    }

    private void checkRequestLine(Client client) throws IOException {
        if (!"GET".equalsIgnoreCase(client.httpRequestMeta.method)) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u65b9\u6cd5\u5fc5\u987b\u4e3aget!\u5ba2\u6237\u7aef\u65b9\u6cd5:" + client.httpRequestMeta.method);
        }
        if (!"HTTP/1.1".equalsIgnoreCase(client.httpRequestMeta.protocol)) {
            throw new HttpStatusException(400, "\u5f53\u524d\u4ec5\u652f\u6301HTTP/1.1!\u5ba2\u6237\u7aef\u7248\u672c:" + client.httpRequestMeta.protocol);
        }
    }

    private String checkRequestHeader(Client client) throws IOException {
        if (!client.httpRequestMeta.headers.containsKey("host")) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u5934\u90e8\u672a\u5305\u542bhost!");
        }
        if (!client.httpRequestMeta.headers.containsKey("upgrade") || !"websocket".equalsIgnoreCase(client.httpRequestMeta.headers.get("upgrade").get(0))) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u5934\u90e8\u672a\u5305\u542bupgrade\u6216\u8005upgrade\u7684\u503c\u4e0d\u4e3awebsocket!");
        }
        if (!client.httpRequestMeta.headers.containsKey("connection") || !"upgrade".equalsIgnoreCase(client.httpRequestMeta.headers.get("connection").get(0))) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u5934\u90e8\u672a\u5305\u542bconnection\u6216\u8005connection\u7684\u503c\u4e0d\u4e3aupgrade!");
        }
        if (!client.httpRequestMeta.headers.containsKey("Sec-WebSocket-Key")) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u5934\u90e8\u672a\u5305\u542bSec-WebSocket-Key!");
        }
        if (!client.httpRequestMeta.headers.containsKey("Sec-WebSocket-Version") || !"13".equalsIgnoreCase(client.httpRequestMeta.headers.get("Sec-WebSocket-Version").get(0))) {
            throw new HttpStatusException(400, "\u8bf7\u6c42\u5934\u90e8\u672a\u5305\u542bSec-WebSocket-Version\u6216\u8005Sec-WebSocket-Version\u7684\u503c\u4e0d\u4e3a13!");
        }
        return client.httpRequestMeta.headers.get("Sec-WebSocket-Key").get(0);
    }

    private void sendHandshakeFailureResponse(HttpStatusException e) {
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append("HTTP/1.1 " + e.getStatus() + ' ' + HttpStatus.getStatus((int)e.getStatus()).statusMessage + "\r\n");
        responseBuilder.append("Connection: close\r\n");
        responseBuilder.append("Content-Length: " + e.getDescription().getBytes(StandardCharsets.UTF_8).length + "\r\n");
        responseBuilder.append("\r\n");
        responseBuilder.append(e.getDescription());
        this.logger.trace("\u670d\u52a1\u7aef\u54cd\u5e94\u9519\u8bef\u62a5\u6587:\r\n{}", (Object)responseBuilder.toString());
        try {
            this.webSocketFrameStream.getWebSocketStream().write(responseBuilder.toString().getBytes(StandardCharsets.UTF_8));
            this.webSocketFrameStream.getWebSocketStream().flush();
        }
        catch (IOException ex) {
            this.logger.error("\u5199\u5165\u670d\u52a1\u7aef\u54cd\u5e94\u62a5\u6587\u5931\u8d25", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWebSocketFrame(Client client) {
        WebSocketSessionImpl webSocketSession = new WebSocketSessionImpl(this.webSocketFrameStream);
        try {
            client.webSocketServerListener.onOpen(webSocketSession);
            WebSocketFrame clientWebSocketFrame = this.webSocketFrameStream.getClientWebSocketFrame();
            while (!OPCode.Close.equals((Object)clientWebSocketFrame.opCode)) {
                switch (clientWebSocketFrame.opCode) {
                    case PingFrame: {
                        this.logger.trace("\u5ba2\u6237\u7aef\u53d1\u9001\u4e86Ping\u5e27,\u670d\u52a1\u7aef\u56de\u5e94Pong\u5e27");
                        WebSocketFrame webSocketFrame = new WebSocketFrame();
                        webSocketFrame.fin = true;
                        webSocketFrame.opCode = OPCode.PongFrame;
                        webSocketFrame.mask = false;
                        this.webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
                        break;
                    }
                    case PongFrame: {
                        this.logger.trace("\u5ba2\u6237\u7aef\u53d1\u9001\u4e86PongFrame,\u670d\u52a1\u7aef\u4e0d\u505a\u4efb\u4f55\u56de\u5e94");
                        break;
                    }
                    case TextFrame: {
                        String text = new String(clientWebSocketFrame.payload, StandardCharsets.UTF_8);
                        client.webSocketServerListener.onTextMessage(text, webSocketSession);
                        break;
                    }
                    case BinaryFrame: {
                        client.webSocketServerListener.onBinaryMessage(clientWebSocketFrame.payload, webSocketSession);
                        break;
                    }
                    default: {
                        this.logger.warn("\u5f53\u524d\u65e0\u6cd5\u5904\u7406\u7684\u5e27\u7c7b\u578b:{}", (Object)clientWebSocketFrame.opCode);
                    }
                }
                clientWebSocketFrame = this.webSocketFrameStream.getClientWebSocketFrame();
            }
            if (clientWebSocketFrame.payloadLength > 0L) {
                try {
                    String description = new String(clientWebSocketFrame.payload, 2, clientWebSocketFrame.payload.length - 2, StandardCharsets.UTF_8);
                    this.logger.debug("\u94fe\u63a5\u5173\u95ed!\u5173\u95ed\u539f\u56e0:{}, \u63cf\u8ff0:{}", (Object)clientWebSocketFrame.closeCode, (Object)description);
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u5ba2\u6237\u7aef\u5173\u95ed\u539f\u56e0\u65f6\u5f02\u5e38", (Throwable)e);
                }
            }
            client.webSocketServerListener.onClose(webSocketSession);
        }
        catch (Exception e) {
            try {
                client.webSocketServerListener.onError(e, webSocketSession);
            }
            catch (IOException ex) {
                this.logger.error("websocket\u5904\u7406onError\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
        finally {
            try {
                client.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

