/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.DispatcherHandler;
import cn.schoolwow.quickserver.handler.Handler;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);

    @Override
    public Handler handle(Client client) throws IOException {
        String sessionId = this.getSessionId(client);
        if (null == sessionId) {
            this.logger.trace("\u7b2c\u4e00\u6b21\u8bbf\u95ee,\u51c6\u5907\u6ce8\u518c\u4f1a\u8bdd");
            client.httpSessionMeta.id = UUID.randomUUID().toString();
            client.httpSessionMeta.createdTime = System.currentTimeMillis();
            client.serverConfigMeta.sessionMap.put(client.httpSessionMeta.id, client.httpSessionMeta);
            HttpCookie sessionCookie = new HttpCookie("quickServerSession", client.httpSessionMeta.id);
            sessionCookie.setPath("/");
            sessionCookie.setHttpOnly(true);
            sessionCookie.setSecure(false);
            sessionCookie.setMaxAge(client.serverConfigMeta.sessionTimeout);
            sessionCookie.setVersion(0);
            client.httpResponse.addCookie(sessionCookie);
            this.logger.trace("\u521b\u5efa\u4f1a\u8bdd,\u4f1a\u8bddid:{}", (Object)client.httpSessionMeta.id);
        } else if (!client.serverConfigMeta.sessionMap.containsKey(sessionId)) {
            this.logger.trace("\u4f1a\u8bdd\u4e0d\u5b58\u5728,\u4f1a\u8bddid:{}", (Object)client.httpSessionMeta.id);
        } else {
            this.logger.trace("\u4f1a\u8bdd\u5df2\u5b58\u5728,\u66f4\u65b0\u4f1a\u8bdd\u6d3b\u8dc3\u65f6\u95f4,\u4f1a\u8bddid:{},\u4e0a\u6b21\u8bbf\u95ee:{}", (Object)sessionId, (Object)new Date(client.httpSessionMeta.lastAccessedTime));
            client.httpSessionMeta = client.serverConfigMeta.sessionMap.get(sessionId);
            client.httpSessionMeta.lastAccessedTime = System.currentTimeMillis();
        }
        return new DispatcherHandler();
    }

    private String getSessionId(Client client) {
        for (HttpCookie httpCookie : client.httpRequestMeta.cookieList) {
            if (!"quickServerSession".equalsIgnoreCase(httpCookie.getName())) continue;
            return httpCookie.getValue();
        }
        return null;
    }
}

