/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.ControllerMeta;
import cn.schoolwow.quickserver.handler.AnnotationHandler;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.handler.StaticResourceHandler;
import cn.schoolwow.quickserver.handler.WebSocketHandler;
import cn.schoolwow.quickserver.interceptor.HandlerInterceptor;
import cn.schoolwow.quickserver.interceptor.Interceptor;
import cn.schoolwow.quickserver.util.AntPathMatcherUtil;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import cn.schoolwow.quickserver.websocket.WebSocketServerListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(DispatcherHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        Collection interceptorList = client.serverConfigMeta.applicationContext.getBeansOfType(HandlerInterceptor.class).values();
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor) || handlerInterceptor.preHandle(client.httpRequest, client.httpResponse, client.httpSession)) continue;
            return new HttpResponseHandler();
        }
        this.getControllerMeta(client);
        this.getWebsocketServerListener(client);
        Handler handler = null;
        if (null != client.controllerMeta) {
            this.logger.trace("\u5904\u7406\u65b9\u5f0f\u4e3aController,\u5904\u7406\u65b9\u6cd5:{}", (Object)client.controllerMeta.method.toString());
            handler = new AnnotationHandler();
        } else if (null != client.webSocketServerListener) {
            this.logger.trace("\u5904\u7406\u65b9\u5f0f\u4e3aWebSocket,\u5904\u7406\u65b9\u6cd5:{}", (Object)client.webSocketServerListener.getClass().getName());
            handler = new WebSocketHandler();
        } else {
            this.logger.trace("\u5904\u7406\u65b9\u5f0f\u4e3a\u9759\u6001\u8d44\u6e90");
            handler = new StaticResourceHandler();
        }
        while (null != handler && !(handler instanceof HttpResponseHandler)) {
            try {
                handler = handler.handle(client);
            }
            catch (Exception e) {
                QuickServerUtil.handleExceptionHandler(client, e);
                handler = new HttpResponseHandler();
            }
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor)) continue;
            handlerInterceptor.postHandle(client.httpRequest, client.httpResponse, client.httpSession);
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor)) continue;
            handlerInterceptor.beforeResponse(client.httpRequest, client.httpResponse, client.httpSession);
        }
        return handler;
    }

    private void getControllerMeta(Client client) {
        for (ControllerMeta controllerMeta : client.serverConfigMeta.controllerMetaList) {
            String mappingUrl;
            int urlPos = 0;
            int mappingPos = 0;
            int lastUrlPos = 0;
            int lastMappingPos = 0;
            String requestPath = client.httpRequestMeta.uri.getPath();
            String antRequestUrl = mappingUrl = controllerMeta.mappingUrl;
            while (urlPos < requestPath.length() && mappingPos < mappingUrl.length()) {
                if (mappingUrl.charAt(mappingPos) == '{') {
                    lastUrlPos = urlPos;
                    lastMappingPos = mappingPos + 1;
                    while (mappingPos < mappingUrl.length() && mappingUrl.charAt(mappingPos) != '}') {
                        ++mappingPos;
                    }
                    if (mappingPos >= mappingUrl.length()) continue;
                    String name = mappingUrl.substring(lastMappingPos, mappingPos);
                    antRequestUrl = antRequestUrl.replace("{" + name + "}", "*");
                    String value = null;
                    if (mappingPos + 1 < mappingUrl.length()) {
                        while (urlPos < requestPath.length() && requestPath.charAt(urlPos) != mappingUrl.charAt(mappingPos + 1)) {
                            ++urlPos;
                        }
                        if (urlPos < requestPath.length()) {
                            value = requestPath.substring(lastUrlPos, urlPos);
                        }
                    } else {
                        value = requestPath.substring(lastUrlPos);
                    }
                    client.httpRequestMeta.pathVariable.put(name, value);
                    continue;
                }
                if (requestPath.charAt(urlPos) == mappingUrl.charAt(mappingPos)) {
                    ++urlPos;
                    ++mappingPos;
                    continue;
                }
                ++mappingPos;
            }
            if ((!mappingUrl.contains("{") || !AntPathMatcherUtil.match(requestPath, antRequestUrl)) && !requestPath.equals(mappingUrl)) continue;
            for (RequestMethod requestMethod : controllerMeta.requestMethodList) {
                if (!requestMethod.name().equalsIgnoreCase(client.httpRequestMeta.method)) continue;
                this.logger.trace("\u5339\u914dController,\u8def\u5f84:{},\u5904\u7406\u65b9\u6cd5:{}", (Object)client.httpRequestMeta.uri.getPath(), (Object)controllerMeta.method.toString());
                client.controllerMeta = controllerMeta;
                return;
            }
        }
    }

    private void getWebsocketServerListener(Client client) {
        Set<Map.Entry<String, WebSocketServerListener>> entrySet = client.serverConfigMeta.uriWebSocketServerListenerMap.entrySet();
        for (Map.Entry<String, WebSocketServerListener> entry : entrySet) {
            if (!entry.getKey().equalsIgnoreCase(client.httpRequestMeta.uri.getPath())) continue;
            this.logger.trace("\u5339\u914dWebSocket\u76d1\u542c\u5668,\u7c7b\u540d:{}", (Object)entry.getValue().getClass().getName());
            client.webSocketServerListener = entry.getValue();
            break;
        }
    }

    private boolean matchInterceptor(Client client, HandlerInterceptor handlerInterceptor) {
        String uri = client.httpRequestMeta.uri.getPath();
        Interceptor interceptor = handlerInterceptor.getClass().getDeclaredAnnotation(Interceptor.class);
        if (null == interceptor) {
            return false;
        }
        for (String excludePattern : interceptor.excludePatterns()) {
            if (!AntPathMatcherUtil.match(uri, excludePattern)) continue;
            return false;
        }
        if (interceptor.excludeStaticResource() && null == client.controllerMeta) {
            return false;
        }
        for (String pattern : interceptor.patterns()) {
            if (!AntPathMatcherUtil.match(uri, pattern)) continue;
            return true;
        }
        return false;
    }
}

