/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.controller.annotation.CookieValue;
import cn.schoolwow.quickserver.controller.annotation.PathVariable;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestHeader;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RequestPart;
import cn.schoolwow.quickserver.controller.annotation.SessionValue;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.MultipartFile;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.request.HttpRequest;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.response.HttpStatus;
import cn.schoolwow.quickserver.session.HttpSession;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.net.HttpCookie;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(ControllerHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        Object[] parameterArray = this.getMethodParameter(client);
        this.logger.debug("\u8c03\u7528Controller,\u7c7b\u540d:{},\u65b9\u6cd5\u540d:{},\u53c2\u6570\u5217\u8868:{}", new Object[]{client.controllerMeta.method.getDeclaringClass().getName(), client.controllerMeta.method.getName(), Arrays.toString(parameterArray)});
        Object result = client.controllerMeta.method.invoke(client.controllerMeta.instance, parameterArray);
        if (null != client.serverConfigMeta.responseBodyAdvice && client.serverConfigMeta.responseBodyAdvice.support(client.controllerMeta.method)) {
            result = client.serverConfigMeta.responseBodyAdvice.beforeBodyWrite(result, client.controllerMeta.method, client.httpRequest, client.httpResponse, client.httpSession);
        }
        this.handleResult(result, client);
        return new HttpResponseHandler();
    }

    private Object[] getMethodParameter(Client client) throws Exception {
        Object[] parameterArray = new Object[client.controllerMeta.method.getParameterCount()];
        Parameter[] parameters = client.controllerMeta.method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Object parameterValue = this.getAutoWireType(client, parameter);
            if (null == parameterValue) {
                parameterValue = this.getPathVariable(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestParam(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestPart(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestBody(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getSessionValue(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestHeader(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getCookieValue(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getCompositeParameter(client, parameter);
            }
            if (null == parameterValue) continue;
            parameterArray[i] = TypeUtils.cast((Object)parameterValue, parameter.getType(), null);
        }
        return parameterArray;
    }

    private Object getAutoWireType(Client client, Parameter parameter) {
        if (parameter.getType().getName().equals(HttpRequest.class.getName())) {
            return client.httpRequest;
        }
        if (parameter.getType().getName().equals(HttpResponse.class.getName())) {
            return client.httpResponse;
        }
        if (parameter.getType().getName().equals(HttpSession.class.getName())) {
            return client.httpSession;
        }
        return null;
    }

    private Object getPathVariable(Client client, Parameter parameter) {
        PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
        if (null == pathVariable) {
            return null;
        }
        if (pathVariable.required() && !client.httpRequestMeta.pathVariable.containsKey(pathVariable.name())) {
            throw new IllegalArgumentException("\u8def\u5f84\u53d8\u91cf[" + pathVariable.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return client.httpRequestMeta.pathVariable.get(pathVariable.name());
    }

    private Object getRequestParam(Client client, Parameter parameter) throws ParseException {
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if (null == requestParam) {
            return null;
        }
        String requestParameter = client.httpRequestMeta.dataMap.get(requestParam.name());
        if (requestParam.required() && requestParameter == null) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestParam.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (requestParameter == null || requestParameter.isEmpty()) {
            requestParameter = requestParam.defaultValue();
        }
        String pattern = requestParam.pattern();
        if (requestParam.required() && !pattern.isEmpty() && requestParameter.isEmpty()) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestParam.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!pattern.isEmpty() && !requestParameter.isEmpty()) {
            return this.getDateParameterByType(pattern, parameter.getType(), requestParameter);
        }
        return requestParameter;
    }

    private Object getRequestPart(Client client, Parameter parameter) throws ParseException {
        RequestPart requestPart = parameter.getAnnotation(RequestPart.class);
        if (null == requestPart) {
            return null;
        }
        switch (parameter.getType().getName()) {
            case "cn.schoolwow.quickserver.domain.MultipartFile": {
                List<MultipartFile> multipartFileList = client.httpRequestMeta.fileParameterMap.get(requestPart.name());
                if (requestPart.required() && (multipartFileList == null || multipartFileList.isEmpty())) {
                    throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (null == multipartFileList || multipartFileList.isEmpty()) {
                    return null;
                }
                return multipartFileList.get(0);
            }
            case "[Lcn.schoolwow.quickserver.domain.MultipartFile;": {
                List<MultipartFile> multipartFileList = client.httpRequestMeta.fileParameterMap.get(requestPart.name());
                if (requestPart.required() && (multipartFileList == null || multipartFileList.isEmpty())) {
                    throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (null == multipartFileList || multipartFileList.isEmpty()) {
                    return new MultipartFile[0];
                }
                return multipartFileList;
            }
        }
        if (requestPart.required() && !client.httpRequestMeta.dataMap.containsKey(requestPart.name())) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String requestParameter = client.httpRequestMeta.dataMap.get(requestPart.name());
        if (requestParameter == null || requestParameter.isEmpty()) {
            requestParameter = requestPart.defaultValue();
        }
        String pattern = requestPart.pattern();
        if (requestPart.required() && !pattern.isEmpty() && requestParameter.isEmpty()) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!pattern.isEmpty() && !requestParameter.isEmpty()) {
            return this.getDateParameterByType(pattern, parameter.getType(), requestParameter);
        }
        return requestParameter;
    }

    private Object getRequestBody(Client client, Parameter parameter) {
        RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
        if (null == requestBody) {
            return null;
        }
        Class<?> type = parameter.getType();
        if (this.isPrimitiveType(type)) {
            return TypeUtils.cast((Object)client.httpRequestMeta.body, parameter.getType(), null);
        }
        if (type.getName().equals(String.class.getName())) {
            return client.httpRequestMeta.body;
        }
        if (client.httpRequestMeta.body.startsWith("{")) {
            if (parameter.getType().getName().equals(JSONObject.class.getName())) {
                return JSON.parseObject((String)client.httpRequestMeta.body);
            }
            return JSON.parseObject((String)client.httpRequestMeta.body).toJavaObject(parameter.getType());
        }
        if (client.httpRequestMeta.body.startsWith("[")) {
            if (parameter.getType().getName().equals(JSONArray.class.getName())) {
                return JSON.parseArray((String)client.httpRequestMeta.body);
            }
            return JSON.parseArray((String)client.httpRequestMeta.body).toJavaList(parameter.getType().getComponentType());
        }
        if (requestBody.required()) {
            throw new IllegalArgumentException("@RequestBody\u6ce8\u89e3\u65e0\u6cd5\u89e3\u6790\u8be5JSON\u53c2\u6570!\u53c2\u6570\u540d\u79f0:" + parameter.getName() + ",\u53c2\u6570\u503c:" + client.httpRequestMeta.body);
        }
        return null;
    }

    private Object getSessionValue(Client client, Parameter parameter) {
        SessionValue sessionValue = parameter.getAnnotation(SessionValue.class);
        if (null == sessionValue) {
            return null;
        }
        if (sessionValue.required() && !client.httpSessionMeta.attributes.containsKey(sessionValue.name())) {
            throw new IllegalArgumentException("SessionValue\u6ce8\u89e3[" + sessionValue.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Object parameterValue = client.httpSessionMeta.attributes.get(sessionValue.name());
        this.logger.trace("[SessionValue]name:{},value:{},defaultValue:{}", new Object[]{sessionValue.name(), parameterValue, sessionValue.defaultValue()});
        if (null == parameterValue) {
            parameterValue = sessionValue.defaultValue();
        }
        return parameterValue;
    }

    private Object getRequestHeader(Client client, Parameter parameter) {
        RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (null == requestHeader) {
            return null;
        }
        List<String> requestHeaderValues = client.httpRequestMeta.headers.get(requestHeader.name());
        if (requestHeader.required() && null == requestHeaderValues) {
            throw new IllegalArgumentException("http\u5934\u90e8[" + requestHeader.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String parameterValue = null == requestHeaderValues ? null : requestHeaderValues.get(0);
        this.logger.trace("[RequestHeader]name:{},value:{},defaultValue:{}", new Object[]{requestHeader.name(), parameterValue, requestHeader.defaultValue()});
        if (null == parameterValue) {
            parameterValue = requestHeader.defaultValue();
        }
        return parameterValue;
    }

    private Object getCookieValue(Client client, Parameter parameter) {
        CookieValue cookieValue = parameter.getAnnotation(CookieValue.class);
        if (null == cookieValue) {
            return null;
        }
        HttpCookie httpCookie = null;
        for (HttpCookie _httpCookie : client.httpRequestMeta.cookieList) {
            if (!_httpCookie.getName().equals(cookieValue.name())) continue;
            httpCookie = _httpCookie;
            break;
        }
        if (null == httpCookie) {
            throw new IllegalArgumentException("Cookie[" + cookieValue.name() + "]\u4e0d\u5b58\u5728!");
        }
        return httpCookie.getValue();
    }

    private Object getCompositeParameter(Client client, Parameter parameter) throws Exception {
        Class<?> parameterType = parameter.getType();
        if (this.isPrimitiveType(parameterType) || "java.lang.String".equals(parameterType.getName())) {
            return null;
        }
        Object instance = parameterType.newInstance();
        AccessibleObject[] fields = parameterType.getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!client.httpRequestMeta.dataMap.containsKey(((Field)field).getName())) continue;
            ((Field)field).set(instance, client.httpRequestMeta.dataMap.get(((Field)field).getName()));
        }
        return instance;
    }

    private void handleResult(Object result, Client client) throws IOException {
        if (null == result) {
            return;
        }
        if (result instanceof byte[]) {
            if (null == client.httpResponseMeta.contentType) {
                client.httpResponseMeta.contentType = "text/plain";
            }
            byte[] bytes = (byte[])result;
            client.httpResponseMeta.result = QuickServerUtil.byteArrayToHex(bytes);
            client.httpResponseMeta.contentLength = bytes.length;
            client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
            return;
        }
        String resultString = result.toString();
        if (resultString.startsWith("redirect:")) {
            client.httpResponse.httpStatus(HttpStatus.FOUND);
            client.httpResponseMeta.headers.put("Location", Arrays.asList(resultString.substring("redirect:".length())));
            return;
        }
        if (this.isPrimitiveType(result.getClass()) || result instanceof String) {
            if (null == client.httpResponseMeta.contentType) {
                client.httpResponseMeta.contentType = "text/plain";
            }
            client.httpResponseMeta.result = String.valueOf(result);
            byte[] bytes = client.httpResponseMeta.result.getBytes(client.httpResponseMeta.charset);
            client.httpResponseMeta.contentLength = bytes.length;
            client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
            return;
        }
        if (null == client.httpResponseMeta.contentType) {
            client.httpResponseMeta.contentType = "application/json";
        }
        client.httpResponseMeta.result = JSON.toJSONString((Object)result, (SerializerFeature[])client.serverConfigMeta.serializerFeatures);
        byte[] bytes = client.httpResponseMeta.result.getBytes(client.httpResponseMeta.charset);
        client.httpResponseMeta.contentLength = bytes.length;
        client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
    }

    private Object getDateParameterByType(String pattern, Class parameterType, String requestParameter) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        java.util.Date date = sdf.parse(requestParameter);
        switch (parameterType.getName()) {
            case "java.util.Date": {
                return date;
            }
            case "java.sql.Date": {
                return new Date(date.getTime());
            }
            case "java.sql.Timestamp": {
                return new Timestamp(date.getTime());
            }
            case "java.util.Calendar": {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            case "java.time.LocalDate": {
                return LocalDate.parse(requestParameter, DateTimeFormatter.ofPattern(pattern));
            }
            case "java.time.LocalDateTime": {
                return LocalDateTime.parse(requestParameter, DateTimeFormatter.ofPattern(pattern));
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u7c7b\u578b,\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!\u5f53\u524d\u7c7b\u578b:" + parameterType.getName());
    }

    private boolean isPrimitiveType(Class<?> clazz) {
        try {
            if (clazz.isPrimitive()) {
                return true;
            }
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }
}

