/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.controller.annotation.BasicAuth;
import cn.schoolwow.quickserver.controller.annotation.CrossOrigin;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.ControllerHandler;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.response.HttpStatus;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(AnnotationHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        if (!this.handleBasicAuth(client)) {
            return new HttpResponseHandler();
        }
        if (!this.handleCrossOrigin(client)) {
            return new HttpResponseHandler();
        }
        return new ControllerHandler();
    }

    public boolean handleBasicAuth(Client client) {
        BasicAuth basicAuth = client.controllerMeta.method.getAnnotation(BasicAuth.class);
        if (null == basicAuth) {
            basicAuth = client.controllerMeta.method.getDeclaringClass().getAnnotation(BasicAuth.class);
        }
        if (null == basicAuth) {
            return true;
        }
        this.logger.debug("\u5904\u7406BasicAuth\u6ce8\u89e3,\u5730\u5740:{},\u7528\u6237\u540d:{},\u5bc6\u7801:{}", new Object[]{client.httpRequestMeta.uri, basicAuth.username(), basicAuth.password()});
        if (client.httpRequestMeta.headers.containsKey("Authorization")) {
            String expectAuthorization;
            String authorization = client.httpRequestMeta.headers.get("Authorization").get(0);
            if ((authorization = authorization.substring(authorization.indexOf("Basic ") + 6)).equals(expectAuthorization = new String(Base64.getEncoder().encode((basicAuth.username() + ":" + basicAuth.password()).getBytes())))) {
                this.logger.debug("BasicAuth\u9a8c\u8bc1\u901a\u8fc7");
                return true;
            }
        }
        client.httpResponse.httpStatus(HttpStatus.UNAUTHORIZED);
        client.httpResponseMeta.headers.put("WWW-Authenticate", Arrays.asList("Basic realm=\"" + basicAuth.realm() + "\""));
        return false;
    }

    private boolean handleCrossOrigin(Client client) {
        CrossOrigin crossOriginAnnotation = client.controllerMeta.method.getDeclaredAnnotation(CrossOrigin.class);
        if (null == crossOriginAnnotation) {
            crossOriginAnnotation = client.controllerMeta.method.getDeclaringClass().getDeclaredAnnotation(CrossOrigin.class);
        }
        if (null == crossOriginAnnotation) {
            return true;
        }
        this.logger.debug("\u5904\u7406CrossOrigin\u6ce8\u89e3,\u65b9\u6cd5\u540d:{}", (Object)client.controllerMeta.method.getName());
        if (!client.httpRequestMeta.headers.containsKey("Origin")) {
            this.logger.warn("CrossOrigin\u670d\u52a1\u7aef\u4e3a\u8de8\u57df\u8bf7\u6c42,\u4f46\u5ba2\u6237\u7aef\u65e0Origin\u5934\u90e8!");
            client.httpResponse.httpStatus(HttpStatus.BAD_REQUEST);
            return false;
        }
        String origin = client.httpRequestMeta.headers.get("Origin").get(0);
        boolean allowOrigin = false;
        if (crossOriginAnnotation.origins().length == 0) {
            allowOrigin = true;
        } else {
            String[] crossOrigins;
            for (String crossOrigin : crossOrigins = crossOriginAnnotation.origins()) {
                if (!origin.equalsIgnoreCase(crossOrigin) && !"*".equalsIgnoreCase(crossOrigin)) continue;
                allowOrigin = true;
                break;
            }
        }
        if (!allowOrigin) {
            this.logger.warn("CrossOrigin,origin\u5934\u90e8\u4e0d\u5339\u914d,\u8de8\u57df\u5931\u8d25!\u5ba2\u6237\u7aefOrigin\u5934\u90e8:{}", (Object)origin);
            client.httpResponse.httpStatus(HttpStatus.BAD_REQUEST);
            return false;
        }
        String accessControlRequestMethod = null;
        if (client.httpRequestMeta.headers.containsKey("Access-Control-Allow-Methods")) {
            accessControlRequestMethod = client.httpRequestMeta.headers.get("Access-Control-Allow-Methods").get(0);
        }
        if (null != accessControlRequestMethod && crossOriginAnnotation.methods().length > 0) {
            boolean allowMethod = false;
            for (String method : crossOriginAnnotation.methods()) {
                if (!accessControlRequestMethod.equalsIgnoreCase(method)) continue;
                allowMethod = true;
                break;
            }
            if (!allowMethod) {
                this.logger.warn("CrossOrigin\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5141\u8bb8!\u5ba2\u6237\u7aef\u5934\u90e8Access-Control-Allow-Methods:{}", (Object)accessControlRequestMethod);
                client.httpResponse.httpStatus(HttpStatus.BAD_REQUEST);
                return false;
            }
        }
        String accessControlRequestHeaders = null;
        if (client.httpRequestMeta.headers.containsKey("Access-Control-Allow-Headers")) {
            accessControlRequestHeaders = client.httpRequestMeta.headers.get("Access-Control-Allow-Headers").get(0);
        }
        if (null != accessControlRequestHeaders && crossOriginAnnotation.headers().length > 0) {
            String[] requestHeaders = accessControlRequestHeaders.split(",");
            for (String allowHeader : crossOriginAnnotation.headers()) {
                boolean exist = false;
                for (String requestHeader : requestHeaders) {
                    if (!"*".equals(allowHeader) && !requestHeader.equals(allowHeader)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                this.logger.warn("CrossOrigin,\u8bf7\u6c42\u5934\u90e8\u4e0d\u5141\u8bb8!\u5ba2\u6237\u7aef\u5934\u90e8Access-Control-Allow-Headers:{}", (Object)accessControlRequestHeaders);
                client.httpResponse.httpStatus(HttpStatus.BAD_REQUEST);
                return false;
            }
        }
        if (!client.serverConfigMeta.crossOriginMap.containsKey(client.httpRequestMeta.uri)) {
            HashMap<String, List<String>> crossOriginMap = new HashMap<String, List<String>>();
            crossOriginMap.put("Access-Control-Allow-Origin", Arrays.asList(crossOriginAnnotation.origins().length == 0 ? "*" : origin));
            crossOriginMap.put("Access-Control-Max-Age", Arrays.asList(crossOriginAnnotation.maxAge() + ""));
            if (crossOriginAnnotation.allowCredentials()) {
                crossOriginMap.put("Access-Control-Allow-Credentials", Arrays.asList("true"));
            }
            if (crossOriginAnnotation.methods().length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String method : crossOriginAnnotation.methods()) {
                    stringBuffer.append(method + ",");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                crossOriginMap.put("Access-Control-Allow-Methods", Arrays.asList(stringBuffer.toString()));
            } else if (null != accessControlRequestMethod) {
                crossOriginMap.put("Access-Control-Allow-Methods", Arrays.asList(accessControlRequestMethod));
            }
            StringBuilder builder = new StringBuilder();
            if (crossOriginAnnotation.headers().length > 0) {
                for (String header : crossOriginAnnotation.headers()) {
                    builder.append(header + ",");
                }
                builder.deleteCharAt(builder.length() - 1);
                crossOriginMap.put("Access-Control-Allow-Headers", Arrays.asList(builder.toString()));
            } else if (null != accessControlRequestHeaders) {
                crossOriginMap.put("Access-Control-Allow-Headers", Arrays.asList(accessControlRequestHeaders));
            }
            if (crossOriginAnnotation.exposedHeaders().length > 0) {
                builder.setLength(0);
                for (String exposedHeader : crossOriginAnnotation.exposedHeaders()) {
                    builder.append(exposedHeader + ",");
                }
                builder.deleteCharAt(builder.length() - 1);
                crossOriginMap.put("Access-Control-Expose-Headers", Arrays.asList(builder.toString()));
            }
            client.serverConfigMeta.crossOriginMap.put(client.httpRequestMeta.uri, crossOriginMap);
        }
        client.httpResponseMeta.headers.putAll(client.serverConfigMeta.crossOriginMap.get(client.httpRequestMeta.uri));
        return true;
    }
}

