package cn.schoolwow.quickserver.websocket.domain;

/**关闭状态码*/
public enum CloseCode {
    NORMAL_CLOSURE(1000, "正常关闭"),
    GOING_AWAY(1001, "终端离线"),
    PROTOCOL_ERROR(1002, "协议错误"),
    CANNOT_ACCEPT(1003, "不支持的数据类型"),
    RESERVED(1004, "保留"),
    NO_STATUS_CODE(1005, "保留"),
    CLOSED_ABNORMALLY(1006, "保留"),
    NOT_CONSISTENT(1007, "类型不连续的消息"),
    VIOLATED_POLICY(1008, "违反政策的消息"),
    TOO_BIG(1009, "消息超过限制大小"),
    NO_EXTENSION(1010, "扩展协议协商失败"),
    UNEXPECTED_CONDITION(1011, "内部服务器错误"),
    SERVICE_RESTART(1012, "服务正在重启"),
    TRY_AGAIN_LATER(1013, "稍后重试"),
    TLS_HANDSHAKE_FAILURE(1015, "TLS握手失败");

    public int code;

    public String message;

    CloseCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String toString() {
        return code+"("+message+")";
    }

    /**从报文中获取关闭报文状态*/
    public static CloseCode getCloseCodeByCode(byte[] payload){
        int code = ((payload[0]&0xff)<<8)+(payload[1]&0xff);
        CloseCode[] closeCodes = CloseCode.values();
        for(CloseCode closeCode:closeCodes){
            if(closeCode.code==code){
                return closeCode;
            }
        }
        return null;
    }
}
