package cn.schoolwow.quickserver.websocket;

import cn.schoolwow.quickserver.websocket.domain.OPCode;
import cn.schoolwow.quickserver.websocket.domain.WebSocketFrame;
import cn.schoolwow.quickserver.websocket.domain.WebSocketState;
import cn.schoolwow.quickserver.websocket.stream.WebSocketFrameStream;

import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

/**WebSocket会话*/
public class WebSocketSessionImpl implements WebSocketSession{
    /**WebSocket帧数据流*/
    public WebSocketFrameStream webSocketFrameStream;

    /**当前状态*/
    public WebSocketState webSocketStatus = WebSocketState.Connecting;

    public WebSocketSessionImpl(WebSocketFrameStream webSocketFrameStream) {
        this.webSocketFrameStream = webSocketFrameStream;
    }

    @Override
    public void sendText(String text) throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.fin = true;
        webSocketFrame.opCode = OPCode.TextFrame;
        webSocketFrame.mask = false;
        webSocketFrame.payload = text.getBytes(StandardCharsets.UTF_8);
        webSocketFrame.payloadLength = webSocketFrame.payload.length;
        webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
    }

    @Override
    public void sendBinary(byte[] data) throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.fin = true;
        webSocketFrame.opCode = OPCode.BinaryFrame;
        webSocketFrame.mask = false;
        webSocketFrame.payload = data;
        webSocketFrame.payloadLength = data.length;
        webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
    }

    @Override
    public void close() throws IOException {
        webSocketStatus = WebSocketState.Closing;
        if(webSocketFrameStream.getWebSocketStream().getSocket().isConnected()){
            WebSocketFrame webSocketFrame = new WebSocketFrame();
            webSocketFrame.fin = true;
            webSocketFrame.opCode = OPCode.Close;
            webSocketFrame.mask = false;
            webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
        }
        webSocketStatus = WebSocketState.Closed;
        webSocketFrameStream.getWebSocketStream().close();
    }

    @Override
    public Socket getSocket(){
        return webSocketFrameStream.getWebSocketStream().getSocket();
    }

}
