package cn.schoolwow.quickserver.websocket;

import java.io.IOException;
import java.net.Socket;

public interface WebSocketSession {
    /**
     * 发送文本信息
     * @param text 文本信息
     * */
    void sendText(String text) throws IOException;

    /**
     * 发送二进制信息
     * @param data 二进制信息
     * */
    void sendBinary(byte[] data) throws IOException;

    /**
     * 关闭连接
     * */
    void close() throws IOException;

    /**
     * 获取套接字
     * */
    Socket getSocket();
}
