package cn.schoolwow.quickserver.websocket;

import java.io.IOException;

/**
 * WebSocket协议监听
 * */
public interface WebSocketServerListener {
    /**
     * 创建连接时
     * */
    void onOpen(WebSocketSession webSocketSession) throws IOException;

    /**
     * 收到文本消息时
     * */
    void onTextMessage(String text, WebSocketSession webSocketSession) throws IOException;
    
    /**
     * 收到二进制消息时
     * */
    void onBinaryMessage(byte[] data, WebSocketSession webSocketSession) throws IOException;

    /**
     * 关闭连接时
     * */
    void onClose(WebSocketSession webSocketSession) throws IOException;

    /**
     * 发生异常时
     * */
    void onError(Exception e, WebSocketSession webSocketSession) throws IOException;
}