package cn.schoolwow.quickserver.util;

import java.util.HashMap;
import java.util.Map;

public class MIMEUtil {
    private static Map<String, String> mimetype = new HashMap<>();

    static {
        mimetype.put("3gp", "video/3gpp");
        mimetype.put("aab", "application/x-authoware-bin");
        mimetype.put("aam", "application/x-authoware-map");
        mimetype.put("aas", "application/x-authoware-seg");
        mimetype.put("ai", "application/postscript");
        mimetype.put("aif", "audio/x-aiff");
        mimetype.put("aifc", "audio/x-aiff");
        mimetype.put("aiff", "audio/x-aiff");
        mimetype.put("als", "audio/X-Alpha5");
        mimetype.put("amc", "application/x-mpeg");
        mimetype.put("ani", "application/octet-stream");
        mimetype.put("asc", "text/plain");
        mimetype.put("asd", "application/astound");
        mimetype.put("asf", "video/x-ms-asf");
        mimetype.put("asn", "application/astound");
        mimetype.put("asp", "application/x-asap");
        mimetype.put("asx", "video/x-ms-asf");
        mimetype.put("au", "audio/basic");
        mimetype.put("avb", "application/octet-stream");
        mimetype.put("avi", "video/x-msvideo");
        mimetype.put("awb", "audio/amr-wb");
        mimetype.put("bcpio", "application/x-bcpio");
        mimetype.put("bin", "application/octet-stream");
        mimetype.put("bld", "application/bld");
        mimetype.put("bld2", "application/bld2");
        mimetype.put("bmp", "image/bmp");
        mimetype.put("bpk", "application/octet-stream");
        mimetype.put("bz2", "application/x-bzip2");
        mimetype.put("cal", "image/x-cals");
        mimetype.put("ccn", "application/x-cnc");
        mimetype.put("cco", "application/x-cocoa");
        mimetype.put("cdf", "application/x-netcdf");
        mimetype.put("cgi", "magnus-internal/cgi");
        mimetype.put("chat", "application/x-chat");
        mimetype.put("class", "application/octet-stream");
        mimetype.put("clp", "application/x-msclip");
        mimetype.put("cmx", "application/x-cmx");
        mimetype.put("co", "application/x-cult3d-object");
        mimetype.put("cod", "image/cis-cod");
        mimetype.put("cpio", "application/x-cpio");
        mimetype.put("cpt", "application/mac-compactpro");
        mimetype.put("crd", "application/x-mscardfile");
        mimetype.put("csh", "application/x-csh");
        mimetype.put("csm", "chemical/x-csml");
        mimetype.put("csml", "chemical/x-csml");
        mimetype.put("css", "text/css");
        mimetype.put("cur", "application/octet-stream");
        mimetype.put("dcm", "x-lml/x-evm");
        mimetype.put("dcr", "application/x-director");
        mimetype.put("dcx", "image/x-dcx");
        mimetype.put("dhtml", "text/html");
        mimetype.put("dir", "application/x-director");
        mimetype.put("dll", "application/octet-stream");
        mimetype.put("dmg", "application/octet-stream");
        mimetype.put("dms", "application/octet-stream");
        mimetype.put("doc", "application/msword");
        mimetype.put("dot", "application/x-dot");
        mimetype.put("dvi", "application/x-dvi");
        mimetype.put("dwf", "drawing/x-dwf");
        mimetype.put("dwg", "application/x-autocad");
        mimetype.put("dxf", "application/x-autocad");
        mimetype.put("dxr", "application/x-director");
        mimetype.put("ebk", "application/x-expandedbook");
        mimetype.put("emb", "chemical/x-embl-dl-nucleotide");
        mimetype.put("embl", "chemical/x-embl-dl-nucleotide");
        mimetype.put("eps", "application/postscript");
        mimetype.put("eri", "image/x-eri");
        mimetype.put("es", "audio/echospeech");
        mimetype.put("esl", "audio/echospeech");
        mimetype.put("etc", "application/x-earthtime");
        mimetype.put("etx", "text/x-setext");
        mimetype.put("evm", "x-lml/x-evm");
        mimetype.put("evy", "application/x-envoy");
        mimetype.put("exe", "application/octet-stream");
        mimetype.put("fh4", "image/x-freehand");
        mimetype.put("fh5", "image/x-freehand");
        mimetype.put("fhc", "image/x-freehand");
        mimetype.put("fif", "image/fif");
        mimetype.put("fm", "application/x-maker");
        mimetype.put("fpx", "image/x-fpx");
        mimetype.put("fvi", "video/isivideo");
        mimetype.put("gau", "chemical/x-gaussian-input");
        mimetype.put("gca", "application/x-gca-compressed");
        mimetype.put("gdb", "x-lml/x-gdb");
        mimetype.put("gif", "image/gif");
        mimetype.put("gps", "application/x-gps");
        mimetype.put("gtar", "application/x-gtar");
        mimetype.put("gz", "application/x-gzip");
        mimetype.put("hdf", "application/x-hdf");
        mimetype.put("hdm", "text/x-hdml");
        mimetype.put("hdml", "text/x-hdml");
        mimetype.put("hlp", "application/winhlp");
        mimetype.put("hqx", "application/mac-binhex40");
        mimetype.put("htm", "text/html");
        mimetype.put("html", "text/html");
        mimetype.put("hts", "text/html");
        mimetype.put("ice", "x-conference/x-cooltalk");
        mimetype.put("ico", "application/octet-stream");
        mimetype.put("ief", "image/ief");
        mimetype.put("ifm", "image/gif");
        mimetype.put("ifs", "image/ifs");
        mimetype.put("imy", "audio/melody");
        mimetype.put("ins", "application/x-NET-Install");
        mimetype.put("ips", "application/x-ipscript");
        mimetype.put("ipx", "application/x-ipix");
        mimetype.put("it", "audio/x-mod");
        mimetype.put("itz", "audio/x-mod");
        mimetype.put("ivr", "i-world/i-vrml");
        mimetype.put("j2k", "image/j2k");
        mimetype.put("jad", "text/vnd.sun.j2me.app-descriptor");
        mimetype.put("jam", "application/x-jam");
        mimetype.put("jar", "application/java-archive");
        mimetype.put("jnlp", "application/x-java-jnlp-file");
        mimetype.put("jpe", "image/jpeg");
        mimetype.put("jpeg", "image/jpeg");
        mimetype.put("jpg", "image/jpeg");
        mimetype.put("jpz", "image/jpeg");
        mimetype.put("js", "application/x-javascript");
        mimetype.put("jwc", "application/jwc");
        mimetype.put("kjx", "application/x-kjx");
        mimetype.put("lak", "x-lml/x-lak");
        mimetype.put("latex", "application/x-latex");
        mimetype.put("lcc", "application/fastman");
        mimetype.put("lcl", "application/x-digitalloca");
        mimetype.put("lcr", "application/x-digitalloca");
        mimetype.put("lgh", "application/lgh");
        mimetype.put("lha", "application/octet-stream");
        mimetype.put("lml", "x-lml/x-lml");
        mimetype.put("lmlpack", "x-lml/x-lmlpack");
        mimetype.put("lsf", "video/x-ms-asf");
        mimetype.put("lsx", "video/x-ms-asf");
        mimetype.put("lzh", "application/x-lzh");
        mimetype.put("m13", "application/x-msmediaview");
        mimetype.put("m14", "application/x-msmediaview");
        mimetype.put("m15", "audio/x-mod");
        mimetype.put("m3u", "audio/x-mpegurl");
        mimetype.put("m3url", "audio/x-mpegurl");
        mimetype.put("ma1", "audio/ma1");
        mimetype.put("ma2", "audio/ma2");
        mimetype.put("ma3", "audio/ma3");
        mimetype.put("ma5", "audio/ma5");
        mimetype.put("man", "application/x-troff-man");
        mimetype.put("map", "magnus-internal/imagemap");
        mimetype.put("mbd", "application/mbedlet");
        mimetype.put("mct", "application/x-mascot");
        mimetype.put("mdb", "application/x-msaccess");
        mimetype.put("mdz", "audio/x-mod");
        mimetype.put("me", "application/x-troff-me");
        mimetype.put("mel", "text/x-vmel");
        mimetype.put("mi", "application/x-mif");
        mimetype.put("mid", "audio/midi");
        mimetype.put("midi", "audio/midi");
        mimetype.put("mif", "application/x-mif");
        mimetype.put("mil", "image/x-cals");
        mimetype.put("mio", "audio/x-mio");
        mimetype.put("mmf", "application/x-skt-lbs");
        mimetype.put("mng", "video/x-mng");
        mimetype.put("mny", "application/x-msmoney");
        mimetype.put("moc", "application/x-mocha");
        mimetype.put("mocha", "application/x-mocha");
        mimetype.put("mod", "audio/x-mod");
        mimetype.put("mof", "application/x-yumekara");
        mimetype.put("mol", "chemical/x-mdl-molfile");
        mimetype.put("mop", "chemical/x-mopac-input");
        mimetype.put("mov", "video/quicktime");
        mimetype.put("movie", "video/x-sgi-movie");
        mimetype.put("mp2", "audio/x-mpeg");
        mimetype.put("mp3", "audio/x-mpeg");
        mimetype.put("mp4", "video/mp4");
        mimetype.put("mpc", "application/vnd.mpohun.certificate");
        mimetype.put("mpe", "video/mpeg");
        mimetype.put("mpeg", "video/mpeg");
        mimetype.put("mpg", "video/mpeg");
        mimetype.put("mpg4", "video/mp4");
        mimetype.put("mpga", "audio/mpeg");
        mimetype.put("mpn", "application/vnd.mophun.application");
        mimetype.put("mpp", "application/vnd.ms-project");
        mimetype.put("mps", "application/x-mapserver");
        mimetype.put("mrl", "text/x-mrml");
        mimetype.put("mrm", "application/x-mrm");
        mimetype.put("ms", "application/x-troff-ms");
        mimetype.put("mts", "application/metastream");
        mimetype.put("mtx", "application/metastream");
        mimetype.put("mtz", "application/metastream");
        mimetype.put("mzv", "application/metastream");
        mimetype.put("nar", "application/zip");
        mimetype.put("nbmp", "image/nbmp");
        mimetype.put("nc", "application/x-netcdf");
        mimetype.put("ndb", "x-lml/x-ndb");
        mimetype.put("ndwn", "application/ndwn");
        mimetype.put("nif", "application/x-nif");
        mimetype.put("nmz", "application/x-scream");
        mimetype.put("nokia-op-logo", "image/vnd.nok-oplogo-color");
        mimetype.put("npx", "application/x-netfpx");
        mimetype.put("nsnd", "audio/nsnd");
        mimetype.put("nva", "application/x-neva1");
        mimetype.put("oda", "application/oda");
        mimetype.put("oom", "application/x-AtlasMate-Plugin");
        mimetype.put("pac", "audio/x-pac");
        mimetype.put("pae", "audio/x-epac");
        mimetype.put("pan", "application/x-pan");
        mimetype.put("pbm", "image/x-portable-bitmap");
        mimetype.put("pcx", "image/x-pcx");
        mimetype.put("pda", "image/x-pda");
        mimetype.put("pdb", "chemical/x-pdb");
        mimetype.put("pdf", "application/pdf");
        mimetype.put("pfr", "application/font-tdpfr");
        mimetype.put("pgm", "image/x-portable-graymap");
        mimetype.put("pict", "image/x-pict");
        mimetype.put("pm", "application/x-perl");
        mimetype.put("pmd", "application/x-pmd");
        mimetype.put("png", "image/png");
        mimetype.put("pnm", "image/x-portable-anymap");
        mimetype.put("pnz", "image/png");
        mimetype.put("pot", "application/vnd.ms-powerpoint");
        mimetype.put("ppm", "image/x-portable-pixmap");
        mimetype.put("pps", "application/vnd.ms-powerpoint");
        mimetype.put("ppt", "application/vnd.ms-powerpoint");
        mimetype.put("pqf", "application/x-cprplayer");
        mimetype.put("pqi", "application/cprplayer");
        mimetype.put("prc", "application/x-prc");
        mimetype.put("proxy", "application/x-ns-proxy-autoconfig");
        mimetype.put("ps", "application/postscript");
        mimetype.put("ptlk", "application/listenup");
        mimetype.put("pub", "application/x-mspublisher");
        mimetype.put("pvx", "video/x-pv-pvx");
        mimetype.put("qcp", "audio/vnd.qcelp");
        mimetype.put("qt", "video/quicktime");
        mimetype.put("qti", "image/x-quicktime");
        mimetype.put("qtif", "image/x-quicktime");
        mimetype.put("r3t", "text/vnd.rn-realtext3d");
        mimetype.put("ra", "audio/x-pn-realaudio");
        mimetype.put("ram", "audio/x-pn-realaudio");
        mimetype.put("rar", "application/x-rar-compressed");
        mimetype.put("ras", "image/x-cmu-raster");
        mimetype.put("rdf", "application/rdf+xml");
        mimetype.put("rf", "image/vnd.rn-realflash");
        mimetype.put("rgb", "image/x-rgb");
        mimetype.put("rlf", "application/x-richlink");
        mimetype.put("rm", "audio/x-pn-realaudio");
        mimetype.put("rmf", "audio/x-rmf");
        mimetype.put("rmm", "audio/x-pn-realaudio");
        mimetype.put("rmvb", "audio/x-pn-realaudio");
        mimetype.put("rnx", "application/vnd.rn-realplayer");
        mimetype.put("roff", "application/x-troff");
        mimetype.put("rp", "image/vnd.rn-realpix");
        mimetype.put("rpm", "audio/x-pn-realaudio-plugin");
        mimetype.put("rt", "text/vnd.rn-realtext");
        mimetype.put("rte", "x-lml/x-gps");
        mimetype.put("rtf", "application/rtf");
        mimetype.put("rtg", "application/metastream");
        mimetype.put("rtx", "text/richtext");
        mimetype.put("rv", "video/vnd.rn-realvideo");
        mimetype.put("rwc", "application/x-rogerwilco");
        mimetype.put("s3m", "audio/x-mod");
        mimetype.put("s3z", "audio/x-mod");
        mimetype.put("sca", "application/x-supercard");
        mimetype.put("scd", "application/x-msschedule");
        mimetype.put("sdf", "application/e-score");
        mimetype.put("sea", "application/x-stuffit");
        mimetype.put("sgm", "text/x-sgml");
        mimetype.put("sgml", "text/x-sgml");
        mimetype.put("sh", "application/x-sh");
        mimetype.put("shar", "application/x-shar");
        mimetype.put("shtml", "magnus-internal/parsed-html");
        mimetype.put("shw", "application/presentations");
        mimetype.put("si6", "image/si6");
        mimetype.put("si7", "image/vnd.stiwap.sis");
        mimetype.put("si9", "image/vnd.lgtwap.sis");
        mimetype.put("sis", "application/vnd.symbian.install");
        mimetype.put("sit", "application/x-stuffit");
        mimetype.put("skd", "application/x-Koan");
        mimetype.put("skm", "application/x-Koan");
        mimetype.put("skp", "application/x-Koan");
        mimetype.put("skt", "application/x-Koan");
        mimetype.put("slc", "application/x-salsa");
        mimetype.put("smd", "audio/x-smd");
        mimetype.put("smi", "application/smil");
        mimetype.put("smil", "application/smil");
        mimetype.put("smp", "application/studiom");
        mimetype.put("smz", "audio/x-smd");
        mimetype.put("snd", "audio/basic");
        mimetype.put("spc", "text/x-speech");
        mimetype.put("spl", "application/futuresplash");
        mimetype.put("spr", "application/x-sprite");
        mimetype.put("sprite", "application/x-sprite");
        mimetype.put("spt", "application/x-spt");
        mimetype.put("src", "application/x-wais-source");
        mimetype.put("stk", "application/hyperstudio");
        mimetype.put("stm", "audio/x-mod");
        mimetype.put("sv4cpio", "application/x-sv4cpio");
        mimetype.put("sv4crc", "application/x-sv4crc");
        mimetype.put("svf", "image/vnd");
        mimetype.put("svg", "image/svg-xml");
        mimetype.put("svh", "image/svh");
        mimetype.put("svr", "x-world/x-svr");
        mimetype.put("swf", "application/x-shockwave-flash");
        mimetype.put("swfl", "application/x-shockwave-flash");
        mimetype.put("t", "application/x-troff");
        mimetype.put("tad", "application/octet-stream");
        mimetype.put("talk", "text/x-speech");
        mimetype.put("tar", "application/x-tar");
        mimetype.put("taz", "application/x-tar");
        mimetype.put("tbp", "application/x-timbuktu");
        mimetype.put("tbt", "application/x-timbuktu");
        mimetype.put("tcl", "application/x-tcl");
        mimetype.put("tex", "application/x-tex");
        mimetype.put("texi", "application/x-texinfo");
        mimetype.put("texinfo", "application/x-texinfo");
        mimetype.put("tgz", "application/x-tar");
        mimetype.put("thm", "application/vnd.eri.thm");
        mimetype.put("tif", "image/tiff");
        mimetype.put("tiff", "image/tiff");
        mimetype.put("tki", "application/x-tkined");
        mimetype.put("tkined", "application/x-tkined");
        mimetype.put("toc", "application/toc");
        mimetype.put("toy", "image/toy");
        mimetype.put("tr", "application/x-troff");
        mimetype.put("trk", "x-lml/x-gps");
        mimetype.put("trm", "application/x-msterminal");
        mimetype.put("tsi", "audio/tsplayer");
        mimetype.put("tsp", "application/dsptype");
        mimetype.put("tsv", "text/tab-separated-values");
        mimetype.put("tsv", "text/tab-separated-values");
        mimetype.put("ttf", "application/octet-stream");
        mimetype.put("ttz", "application/t-time");
        mimetype.put("txt", "text/plain");
        mimetype.put("ult", "audio/x-mod");
        mimetype.put("ustar", "application/x-ustar");
        mimetype.put("uu", "application/x-uuencode");
        mimetype.put("uue", "application/x-uuencode");
        mimetype.put("vcd", "application/x-cdlink");
        mimetype.put("vcf", "text/x-vcard");
        mimetype.put("vdo", "video/vdo");
        mimetype.put("vib", "audio/vib");
        mimetype.put("viv", "video/vivo");
        mimetype.put("vivo", "video/vivo");
        mimetype.put("vmd", "application/vocaltec-media-desc");
        mimetype.put("vmf", "application/vocaltec-media-file");
        mimetype.put("vmi", "application/x-dreamcast-vms-info");
        mimetype.put("vms", "application/x-dreamcast-vms");
        mimetype.put("vox", "audio/voxware");
        mimetype.put("vqe", "audio/x-twinvq-plugin");
        mimetype.put("vqf", "audio/x-twinvq");
        mimetype.put("vql", "audio/x-twinvq");
        mimetype.put("vre", "x-world/x-vream");
        mimetype.put("vrml", "x-world/x-vrml");
        mimetype.put("vrt", "x-world/x-vrt");
        mimetype.put("vrw", "x-world/x-vream");
        mimetype.put("vts", "workbook/formulaone");
        mimetype.put("wav", "audio/x-wav");
        mimetype.put("wax", "audio/x-ms-wax");
        mimetype.put("wbmp", "image/vnd.wap.wbmp");
        mimetype.put("web", "application/vnd.xara");
        mimetype.put("wi", "image/wavelet");
        mimetype.put("wis", "application/x-InstallShield");
        mimetype.put("wm", "video/x-ms-wm");
        mimetype.put("wma", "audio/x-ms-wma");
        mimetype.put("wmd", "application/x-ms-wmd");
        mimetype.put("wmf", "application/x-msmetafile");
        mimetype.put("wml", "text/vnd.wap.wml");
        mimetype.put("wmlc", "application/vnd.wap.wmlc");
        mimetype.put("wmls", "text/vnd.wap.wmlscript");
        mimetype.put("wmlsc", "application/vnd.wap.wmlscriptc");
        mimetype.put("wmlscript", "text/vnd.wap.wmlscript");
        mimetype.put("wmv", "audio/x-ms-wmv");
        mimetype.put("wmx", "video/x-ms-wmx");
        mimetype.put("wmz", "application/x-ms-wmz");
        mimetype.put("wpng", "image/x-up-wpng");
        mimetype.put("wpt", "x-lml/x-gps");
        mimetype.put("wri", "application/x-mswrite");
        mimetype.put("wrl", "x-world/x-vrml");
        mimetype.put("wrz", "x-world/x-vrml");
        mimetype.put("ws", "text/vnd.wap.wmlscript");
        mimetype.put("wsc", "application/vnd.wap.wmlscriptc");
        mimetype.put("wv", "video/wavelet");
        mimetype.put("wvx", "video/x-ms-wvx");
        mimetype.put("wxl", "application/x-wxl");
        mimetype.put("x-gzip", "application/x-gzip");
        mimetype.put("xar", "application/vnd.xara");
        mimetype.put("xbm", "image/x-xbitmap");
        mimetype.put("xdm", "application/x-xdma");
        mimetype.put("xdma", "application/x-xdma");
        mimetype.put("xdw", "application/vnd.fujixerox.docuworks");
        mimetype.put("xht", "application/xhtml+xml");
        mimetype.put("xhtm", "application/xhtml+xml");
        mimetype.put("xhtml", "application/xhtml+xml");
        mimetype.put("xla", "application/vnd.ms-excel");
        mimetype.put("xlc", "application/vnd.ms-excel");
        mimetype.put("xll", "application/x-excel");
        mimetype.put("xlm", "application/vnd.ms-excel");
        mimetype.put("xls", "application/vnd.ms-excel");
        mimetype.put("xlt", "application/vnd.ms-excel");
        mimetype.put("xlw", "application/vnd.ms-excel");
        mimetype.put("xm", "audio/x-mod");
        mimetype.put("xml", "text/xml");
        mimetype.put("xmz", "audio/x-mod");
        mimetype.put("xpi", "application/x-xpinstall");
        mimetype.put("xpm", "image/x-xpixmap");
        mimetype.put("xsit", "text/xml");
        mimetype.put("xsl", "text/xml");
        mimetype.put("xul", "text/xul");
        mimetype.put("xwd", "image/x-xwindowdump");
        mimetype.put("xyz", "chemical/x-pdb");
        mimetype.put("yz1", "application/x-yz1");
        mimetype.put("z", "application/x-compress");
        mimetype.put("zac", "application/x-zaurus-zac");
        mimetype.put("zip", "application/zip");
    }

    /**
     * 根据文件后缀名获取对应MIME类型
     */
    public static String getMIMEType(String name) {
        String mimeType = null;
        if(name.contains(".")){
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        mimeType = mimetype.get(name);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    /**
     * 获取默认的MIME类型
     * */
    public static String getDefaultMIMEType(){
        return "application/octet-stream";
    }
}
