package cn.schoolwow.quickserver.session;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.HttpSessionMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.HttpCookie;
import java.util.Date;
import java.util.Map;

public class HttpSessionImpl implements HttpSession {
    private Logger logger = LoggerFactory.getLogger(HttpSessionImpl.class);

    private Client client;

    public HttpSessionImpl(Client client) {
        this.client = client;
    }


    @Override
    public String getId() {
        return client.httpSessionMeta.id;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return client.httpSessionMeta.attributes;
    }

    @Override
    public Date getCreatedTime() {
        return new Date(client.httpSessionMeta.createdTime);
    }

    @Override
    public Date getLastAccessedTime() {
        return new Date(client.httpSessionMeta.lastAccessedTime);
    }

    @Override
    public void invalidate() {
        logger.debug("[销毁会话]会话id:{}", client.httpSessionMeta.id);
        client.serverConfigMeta.sessionMap.remove(client.httpSessionMeta.id);
        HttpCookie httpCookie = new HttpCookie(HttpSessionMeta.SESSION, client.httpSessionMeta.id);
        httpCookie.setMaxAge(0);
        client.httpResponse.addCookie(httpCookie);
    }
}
