package cn.schoolwow.quickserver.session;

import java.util.Date;
import java.util.Map;

public interface HttpSession {
    /**
     * 获取会话id
     */
    String getId();

    /**
     * 获取会话属性
     */
    Map<String, Object> getAttributes();

    /**
     * 获取创建时间
     */
    Date getCreatedTime();

    /**
     * 获取上次访问时间
     */
    Date getLastAccessedTime();

    /**
     * 注销会话
     */
    void invalidate();
}
