package cn.schoolwow.quickserver.server;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.ServerConfigMeta;
import cn.schoolwow.quickserver.exception.HttpStatusException;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpRequestHandler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.response.SpeedLimitOutputStream;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

/**
 * 客户端线程
 * */
public class HttpClientThread implements Runnable{
    private Logger logger = LoggerFactory.getLogger(HttpClientThread.class);

    /**
     * 客户端Socket
     * */
    private Socket socket;

    /**
     * 服务端配置信息
     * */
    private ServerConfigMeta serverConfigMeta;

    public HttpClientThread(Socket socket, ServerConfigMeta serverConfigMeta) {
        this.socket = socket;
        this.serverConfigMeta = serverConfigMeta;
    }

    @Override
    public void run() {
        Client client = new Client();
        client.socket = socket;
        client.serverConfigMeta = serverConfigMeta;
        while(true){
            client.lastActiveTime = System.currentTimeMillis();
            client.reset();
            client.httpRequestMeta.remoteAddress = client.socket.getInetAddress();
            try {
                client.httpRequestMeta.inputStream = client.socket.getInputStream();
                client.httpResponseMeta.outputStream = client.socket.getOutputStream();
                if(serverConfigMeta.maxLimitSpeed>=128){
                    SpeedLimitOutputStream speedLimitOutputStream = new SpeedLimitOutputStream(client.httpResponseMeta.outputStream);
                    speedLimitOutputStream.setMaxDownloadSpeed(serverConfigMeta.maxLimitSpeed);
                    client.httpResponseMeta.outputStream = speedLimitOutputStream;
                }
                Handler handler = new HttpRequestHandler();
                while (null != handler) {
                    handler = handler.handle(client);
                }
                if(client.socket.isClosed()){
                    break;
                }
            } catch (Exception e){
                QuickServerUtil.handleExceptionHandler(client,e);
                try {
                    new HttpResponseHandler().handle(client);
                } catch (IOException ex) {
                    if((e instanceof SocketException)||(e instanceof HttpStatusException)){
                        logger.debug("链接异常:{},套接字:{}",e.getMessage(),socket);
                    }else{
                        ex.printStackTrace();
                    }
                    try {
                        if(!socket.isClosed()){
                            socket.close();
                        }
                    } catch (IOException ex1) {
                        ex1.printStackTrace();
                    }
                }
                break;
            }
        }
    }

}
