package cn.schoolwow.quickserver.response;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;

public interface HttpResponse {
    /**
     * 指定状态码
     */
    void status(HttpStatus httpStatus);

    /**
     * 指定编码格式
     */
    void charset(String charset);

    /**
     * 添加Cookie信息
     */
    void addCookie(HttpCookie httpCookie);

    /**
     * 获取Header信息
     */
    List<String> getHeader(String name);

    /**
     * 添加Header信息
     */
    void addHeader(String name, String value);

    /**
     * 设置Header信息
     */
    void setHeader(String name, String value);

    /**
     * 获取编码格式
     */
    String getCharset();

    /**
     * 设置编码格式
     */
    void setCharset(String charset);

    /**
     * 设置编码格式
     */
    void setCharset(Charset charset);

    /**
     * 设置Content-Length头部
     */
    void setContentLength(long contentLength);

    /**
     * 获取Content-Type头部信息
     */
    String getContentType();

    /**
     * 设置Content-Type头部信息
     */
    void setContentType(String contentType);

    /**
     * 获取Content-Disposition头部信息
     */
    String getContentDisposition();

    /**
     * 设置Content-Disposition头部信息
     */
    void setContentDisposition(String fileName);

    /**
     * 是否允许分段下载(206状态码)
     */
    void acceptRanges(boolean acceptRanges);

    /**
     * 重定向
     * @param url 重定向地址
     */
    void redirect(String url);

    /**
     * 输出字符串信息
     */
    void streamingBody(String data) throws IOException;

    /**
     * 输出一行字符串信息
     */
    void streamingBodyLine(String data) throws IOException;

    /**
     * 使用EventSource推送事件
     *
     * @param eventSource 推送事件
     */
    void eventSource(EventSource eventSource) throws IOException;

    /**
     * 下载文件
     *
     * @param filePath 文件路径
     */
    void download(String filePath) throws IOException;

    /**
     * 获取输出流
     */
    OutputStream getOutputStream() throws IOException;
}
