package cn.schoolwow.quickserver.request;

import cn.schoolwow.quickserver.domain.HttpRequestMeta;

import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class HttpRequestImpl implements HttpRequest {
    private HttpRequestMeta httpRequestMeta;

    public HttpRequestImpl(HttpRequestMeta httpRequestMeta) {
        this.httpRequestMeta = httpRequestMeta;
    }

    @Override
    public String ip() {
        return httpRequestMeta.ip;
    }

    @Override
    public URI uri() {
        return httpRequestMeta.uri;
    }

    @Override
    public String method() {
        return httpRequestMeta.method;
    }

    @Override
    public String protocol() {
        return httpRequestMeta.protocol;
    }

    @Override
    public String charset() {
        return httpRequestMeta.charset;
    }

    @Override
    public long contentLength() {
        return httpRequestMeta.contentLength;
    }

    @Override
    public String contentType() {
        return httpRequestMeta.contentType;
    }

    @Override
    public boolean hasHeader(String name) {
        return httpRequestMeta.headers.containsKey(name)&&httpRequestMeta.headers.get(name).size()>0;
    }

    @Override
    public String getHeader(String name) {
        return hasHeader(name)?httpRequestMeta.headers.get(name).get(0):null;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return httpRequestMeta.headers;
    }

    @Override
    public List<HttpCookie> cookieList() {
        return httpRequestMeta.cookieList;
    }

    @Override
    public byte[] getBodyAsBytes() {
        return httpRequestMeta.bodyBytes;
    }

    @Override
    public InputStream getInputStream() {
        return httpRequestMeta.inputStream;
    }
}
