package cn.schoolwow.quickserver.request;

import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;

public interface HttpRequest {
    /**
     * 获取客户端ip
     */
    String ip();

    /**
     * 获取请求url
     */
    URI uri();

    /**
     * 获取请求方法
     */
    String method();

    /**
     * 协议版本
     */
    String protocol();

    /**
     * 获取编码格式
     */
    String charset();

    /**
     * 获取Content-Length
     */
    long contentLength();

    /**
     * 获取Content-Type
     */
    String contentType();

    /**
     * http头部是否存在
     */
    boolean hasHeader(String name);

    /**
     * 获取http头部
     */
    String getHeader(String name);

    /**
     * 获取http头部列表
     */
    Map<String, List<String>> getHeaders();

    /**
     * 获取Cookie列表
     */
    List<HttpCookie> cookieList();

    /**
     * 获取输入流字节数组
     */
    byte[] getBodyAsBytes();

    /**
     * 获取输入流
     */
    InputStream getInputStream();
}
