package cn.schoolwow.quickserver.request;

import java.io.IOException;
import java.io.InputStream;

public class FixedLengthInputStream extends InputStream {
    /**
     * 剩余可读取字节
     * */
    private long remaining;

    /**
     * 原始输入流
     * */
    private InputStream inputStream;

    public FixedLengthInputStream(InputStream inputStream, long remaining) {
        this.inputStream = inputStream;
        this.remaining = remaining;
    }

    @Override
    public int read() throws IOException {
        if(remaining>0){
            remaining--;
            return inputStream.read();
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return (int) Math.min(remaining,inputStream.available());
    }
}
