package cn.schoolwow.quickserver.interceptor;

import cn.schoolwow.quickserver.request.HttpRequest;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.session.HttpSession;

import java.io.IOException;

public interface HandlerInterceptor {
    /**
     * 请求处理之前
     *
     * @param httpRequest  http请求
     * @param httpResponse http响应
     * @param httpSession  http会话
     */
    boolean preHandle(HttpRequest httpRequest, HttpResponse httpResponse, HttpSession httpSession) throws IOException;

    /**
     * 请求处理以后
     *
     * @param httpRequest  http请求
     * @param httpResponse http响应
     * @param httpSession  http会话
     */
    void postHandle(HttpRequest httpRequest, HttpResponse httpResponse, HttpSession httpSession) throws IOException;

    /**
     * 响应返回之前
     *
     * @param httpRequest  http请求
     * @param httpResponse http响应
     * @param httpSession  http会话
     */
    void beforeResponse(HttpRequest httpRequest, HttpResponse httpResponse, HttpSession httpSession) throws IOException;
}
