package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * keepAlive处理器
 * */
public class KeepAliveHandler implements Handler{
    Logger logger = LoggerFactory.getLogger(KeepAliveHandler.class);
    @Override
    public Handler handle(Client client) throws Exception {
        if(!client.serverConfigMeta.keepAlive){
            client.socket.close();
            return null;
        }
        List<String> connectionHeader = client.httpRequestMeta.headers.get("Connection");
        //HTTP 1.1版本默认开启Keep-Alive
        if(null==connectionHeader||connectionHeader.isEmpty()||!"close".equalsIgnoreCase(connectionHeader.get(0))){
            logger.trace("缓存客户端套接字:{}", client.socket);
            synchronized (client.serverConfigMeta.keepAliveClientList){
                boolean addClient = true;
                for(Client keepAliveClient:client.serverConfigMeta.keepAliveClientList){
                    if(client.socket.equals(keepAliveClient.socket)){
                        addClient = false;
                        break;
                    }
                }
                if(addClient){
                    client.serverConfigMeta.keepAliveClientList.add(client);
                }
            }
        }else{
            client.socket.close();
        }
        return null;
    }
}
