package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.HttpSessionMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.HttpCookie;
import java.util.Date;
import java.util.UUID;

/**
 * Http会话处理
 */
public class HttpSessionHandler implements Handler {
    private Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);

    @Override
    public Handler handle(Client client) throws IOException {
        String sessionId = getSessionId(client);
        if(null==sessionId){
            logger.trace("第一次访问,准备注册会话");
            client.httpSessionMeta.id = UUID.randomUUID().toString();
            client.httpSessionMeta.createdTime = System.currentTimeMillis();
            client.serverConfigMeta.sessionMap.put(client.httpSessionMeta.id, client.httpSessionMeta);
            HttpCookie sessionCookie = new HttpCookie(HttpSessionMeta.SESSION, client.httpSessionMeta.id);
            sessionCookie.setPath("/");
            sessionCookie.setHttpOnly(true);
            sessionCookie.setSecure(false);
            sessionCookie.setMaxAge(client.serverConfigMeta.sessionTimeout);
            sessionCookie.setVersion(0);
            client.httpResponse.addCookie(sessionCookie);
            logger.trace("创建会话,会话id:{}", client.httpSessionMeta.id);
        }else if(!client.serverConfigMeta.sessionMap.containsKey(sessionId)){
            logger.trace("会话不存在,会话id:{}", client.httpSessionMeta.id);
        }else{
            logger.trace("会话已存在,更新会话活跃时间,会话id:{},上次访问:{}", sessionId, new Date(client.httpSessionMeta.lastAccessedTime));
            client.httpSessionMeta = client.serverConfigMeta.sessionMap.get(sessionId);
            client.httpSessionMeta.lastAccessedTime = System.currentTimeMillis();
        }
        return new DispatcherHandler();
    }

    private String getSessionId(Client client){
        for(HttpCookie httpCookie:client.httpRequestMeta.cookieList){
            if(HttpSessionMeta.SESSION.equalsIgnoreCase(httpCookie.getName())){
                return httpCookie.getValue();
            }
        }
        return null;
    }
}
