package cn.schoolwow.quickserver.domain;

import cn.schoolwow.quickserver.controller.ExceptionHandler;
import cn.schoolwow.quickserver.controller.ResponseBodyAdvice;
import cn.schoolwow.quickserver.websocket.WebSocketServerListener;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 服务器配置信息元数据
 */
public class ServerConfigMeta {
    /**
     * 服务器host
     */
    public String host;

    /**
     * 服务器端口
     */
    public int port;

    /**
     * 静态资源目录前缀
     */
    public String staticResourcePathPrefix = "";

    /**
     * 静态资源目录<资源路径,路径前缀>
     */
    public Map<String,String> staticResourcePathMap = new HashMap<>();

    /**
     * 会话超时时间(秒)
     */
    public int sessionTimeout = 3600;

    /**
     * 会话存储
     */
    public ConcurrentHashMap<String, HttpSessionMeta> sessionMap = new ConcurrentHashMap();

    /**
     * 定时会话检查线程池
     */
    public ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    /**
     * 是否开启keepAlive特性
     * */
    public boolean keepAlive = false;

    /**
     * keepAlive超时时间
     * */
    public int keepAliveTimeout = 5000;

    /**
     * keepAlive套接字池
     */
    public List<Client> keepAliveClientList = new ArrayList<>();

    /**
     * 限制最大速率(kb/s)
     */
    public int maxLimitSpeed;

    /**
     * 指定JSON序列化特性
     */
    public SerializerFeature[] serializerFeatures = new SerializerFeature[]{
            SerializerFeature.DisableCircularReferenceDetect,
            SerializerFeature.SkipTransientField,
            SerializerFeature.WriteDateUseDateFormat,
            SerializerFeature.WriteMapNullValue
    };

    /**
     * IOC容器
     */
    public AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();

    /**
     * Controller列表
     */
    public List<ControllerMeta> controllerMetaList = new ArrayList<>();

    /**
     * websocket映射列表
     * */
    public Map<String, WebSocketServerListener> uriWebSocketServerListenerMap = new ConcurrentHashMap<>();

    /**
     * 缓存跨域头
     */
    public Map<URI, Map<String, List<String>>> crossOriginMap = new ConcurrentHashMap<>();

    /**
     * responseBodyAdvice对象
     */
    public ResponseBodyAdvice responseBodyAdvice;

    /**
     * 统一异常处理对象
     */
    public ExceptionHandler exceptionHandler;

    /**
     * 线程池
     */
    public ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) Executors.newFixedThreadPool(200);
}
