package cn.schoolwow.quickserver.domain;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;

/**
 * 响应元数据
 */
public class HttpResponseMeta {
    /**
     * 协议版本
     */
    public String protocol = "HTTP/1.1";

    /**
     * 状态
     */
    public int status;

    /**
     * 消息
     */
    public String statusMessage;

    /**
     * http头部
     */
    public Map<String, List<String>> headers = new HashMap<>();
    {
        headers.put("Date", Arrays.asList(new Date().toString()));
        headers.put("Server", Arrays.asList("QuickServer2"));
    }

    /**
     * 编码格式
     */
    public String charset = "utf-8";

    /**
     * 编码格式
     */
    public String contentType = "text/plain; charset="+charset;

    /**
     * 输出流大小
     */
    public long contentLength;

    /**
     * 返回头部内容
     */
    public String headerString;

    /**
     * body输入流
     */
    public InputStream bodyInputStream;

    /**
     * 输出流
     */
    public OutputStream outputStream;

    /**
     * 控制器方法输出结果
     * */
    public String result;

}
