package cn.schoolwow.quickserver.domain;

import java.io.InputStream;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.URI;
import java.util.*;

/**
 * 请求元数据
 */
public class HttpRequestMeta {
    /**
     * 客户端地址
     */
    public InetAddress remoteAddress;

    /**
     * 请求行
     */
    public String statusLine;

    /**
     * 客户端真实IP
     */
    public String ip;

    /**
     * 请求方法
     */
    public String method;

    /**
     * 请求路径
     */
    public URI uri;

    /**
     * 协议
     */
    public String protocol;

    /**
     * 编码格式
     */
    public String charset = "utf-8";

    /**
     * 路径映射参数
     */
    public Map<String, String> pathVariable = new HashMap<>();

    /**
     * http头部
     */
    public Map<String, List<String>> headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    /**
     * Cookie列表
     */
    public List<HttpCookie> cookieList = new ArrayList<>();

    /**
     * 表单参数
     */
    public Map<String, String> dataMap = new HashMap<>();

    /**
     * 文件参数列表
     */
    public Map<String, List<MultipartFile>> fileParameterMap = new HashMap<>();

    /**
     * boundary
     */
    public String boundary;

    /**
     * 主体类型
     */
    public String contentType;

    /**
     * 主体长度
     */
    public long contentLength;

    /**
     * 输入字节数组
     */
    public byte[] bodyBytes;

    /**
     * 请求内容
     */
    public String body;

    /**
     * 输入流
     */
    public InputStream inputStream;

}
