package cn.schoolwow.quickserver.domain;

import cn.schoolwow.quickserver.request.HttpRequestImpl;
import cn.schoolwow.quickserver.response.HttpResponseImpl;
import cn.schoolwow.quickserver.session.HttpSession;
import cn.schoolwow.quickserver.session.HttpSessionImpl;
import cn.schoolwow.quickserver.websocket.WebSocketServerListener;

import java.net.Socket;

public class Client {
    /**
     * 套接字
     */
    public Socket socket;

    /**
     * 上次活跃时间
     */
    public long lastActiveTime;

    /**
     * 请求信息
     */
    public HttpRequestMeta httpRequestMeta;

    /**
     * 请求接口
     */
    public HttpRequestImpl httpRequest;

    /**
     * 响应信息
     */
    public HttpResponseMeta httpResponseMeta;

    /**
     * 请求接口
     */
    public HttpResponseImpl httpResponse;

    /**
     * 会话信息
     */
    public HttpSessionMeta httpSessionMeta;

    /**
     * 会话接口
     */
    public HttpSession httpSession;

    /**
     * 服务器配置信息
     */
    public ServerConfigMeta serverConfigMeta;

    /**
     * 控制器信息
     */
    public ControllerMeta controllerMeta;

    /**
     * websocket映射
     */
    public WebSocketServerListener webSocketServerListener;

    /**
     * 重置请求响应信息
     * */
    public void reset(){
        httpRequestMeta = new HttpRequestMeta();
        httpRequest = new HttpRequestImpl(httpRequestMeta);
        httpResponseMeta = new HttpResponseMeta();
        httpResponse = new HttpResponseImpl(this);
        httpSessionMeta = new HttpSessionMeta();
        httpSession = new HttpSessionImpl(this);
    }
}
