package cn.schoolwow.quickserver.controller.annotation;

import cn.schoolwow.quickserver.controller.RequestMethod;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface RequestMapping {
    /**
     * 映射路径
     */
    String value();

    /**
     * 请求方法
     */
    RequestMethod[] method() default {RequestMethod.GET};
}
