/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExpUtil {
    private static Logger logger = LoggerFactory.getLogger(RegExpUtil.class);
    private static Map<String, Pattern> patternMap = new HashMap<String, Pattern>();

    public static String plainMatch(String input, String pattern) {
        int patternStartIndex = -1;
        int patternEndIndex = -1;
        for (int i = 1; i < pattern.length(); ++i) {
            if (pattern.charAt(0) == '(') {
                patternStartIndex = 0;
            }
            if (pattern.charAt(i) == '(' && pattern.charAt(i - 1) != '\\') {
                patternStartIndex = i;
            }
            if (pattern.charAt(0) == ')') {
                patternEndIndex = 0;
            }
            if (pattern.charAt(i) != ')' || pattern.charAt(i - 1) == '\\') continue;
            patternEndIndex = i;
        }
        if (patternEndIndex <= patternStartIndex) {
            logger.warn("[\u5339\u914d\u5931\u8d25]\u6a21\u5f0f\u4e2d\u4e0d\u5305\u542b\u4e2d\u62ec\u53f7");
            return null;
        }
        String prefix = pattern.substring(0, patternStartIndex).replace("\\(", "(").replace("\\)", ")");
        String suffix = pattern.substring(patternEndIndex + 1, pattern.length()).replace("\\(", "(").replace("\\)", ")");
        int inputStartIndex = input.indexOf(prefix);
        if (inputStartIndex < 0) {
            return null;
        }
        int inputEndIndex = input.substring(inputStartIndex + prefix.length(), input.length()).indexOf(suffix);
        if (inputEndIndex < 0) {
            return null;
        }
        return input.substring(inputStartIndex + prefix.length(), inputStartIndex + inputEndIndex + prefix.length());
    }

    public static String getGroup(String input, String patternString, int groupNumber) {
        Pattern pattern = null;
        if (patternMap.containsKey(patternString)) {
            pattern = patternMap.get(patternString);
        } else {
            pattern = Pattern.compile(patternString);
            patternMap.put(patternString, pattern);
        }
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(groupNumber);
        }
        return null;
    }

    public static String getGroup(String input, String patternString, String groupName) {
        Pattern pattern = null;
        if (patternMap.containsKey(patternString)) {
            pattern = patternMap.get(patternString);
        } else {
            pattern = Pattern.compile(patternString);
            patternMap.put(patternString, pattern);
        }
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(groupName);
        }
        return null;
    }
}

