/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.HttpRequestMeta;
import cn.schoolwow.quickserver.domain.MultipartFile;
import cn.schoolwow.quickserver.exception.HttpStatusException;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpSessionHandler;
import cn.schoolwow.quickserver.request.ChunkedInputStream;
import cn.schoolwow.quickserver.request.FixedLengthInputStream;
import cn.schoolwow.quickserver.response.HttpStatus;
import cn.schoolwow.quickserver.util.RegExpUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
implements Handler {
    private static final ThreadLocal<ByteArrayOutputStream> threadLocal = new ThreadLocal();
    private static Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private static String[] ipHeaders = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static String readLine(InputStream inputStream, String charset) throws IOException {
        int b;
        ByteArrayOutputStream baos = threadLocal.get();
        if (null == baos) {
            baos = new ByteArrayOutputStream();
            threadLocal.set(baos);
        }
        baos.reset();
        while ((b = inputStream.read()) != -1) {
            if (b == 13) {
                b = inputStream.read();
                if (b == 10) break;
                baos.write(13);
                baos.write(b);
                continue;
            }
            baos.write(b);
        }
        if (b == -1) {
            inputStream.close();
            return null;
        }
        baos.flush();
        return new String(baos.toByteArray(), charset);
    }

    @Override
    public Handler handle(Client client) throws IOException {
        this.handleStatusLine(client);
        this.handleHeader(client);
        this.getCharset(client.httpRequestMeta);
        this.handleEncoding(client);
        if (client.httpRequestMeta.contentLength > 0L || client.httpRequestMeta.headers.containsKey("Transfer-Encoding")) {
            this.handleExpect(client);
            this.handleContentType(client);
            this.getBodyAsBytes(client.httpRequestMeta);
        } else {
            logger.trace("[\u5ba2\u6237\u7aef\u65e0\u8bf7\u6c42\u4f53]");
        }
        return new HttpSessionHandler();
    }

    private void handleStatusLine(Client client) throws IOException {
        logger.trace("[\u51c6\u5907\u89e3\u6790\u8bf7\u6c42\u884c]");
        String line = HttpRequestHandler.readLine(client.httpRequestMeta.inputStream, client.httpRequestMeta.charset);
        logger.trace("[\u89e3\u6790\u8bf7\u6c42\u884c]{}", (Object)line);
        client.httpRequestMeta.statusLine = line;
        if (null == line || !line.contains(" ")) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST);
        }
        client.httpRequestMeta.method = line.substring(0, line.indexOf(" "));
        client.httpRequestMeta.uri = URI.create(line.substring(client.httpRequestMeta.method.length() + 1, line.lastIndexOf(" ")));
        client.httpRequestMeta.protocol = line.substring(line.lastIndexOf(" ") + 1);
        String rawQuery = client.httpRequestMeta.uri.getRawQuery();
        if (null != rawQuery && !rawQuery.isEmpty()) {
            StringTokenizer st = new StringTokenizer(rawQuery, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                client.httpRequestMeta.dataMap.put(token.substring(0, token.indexOf("=")), URLDecoder.decode(token.substring(token.indexOf("=") + 1), client.httpRequestMeta.charset));
            }
        }
    }

    private void handleHeader(Client client) throws IOException {
        String line = HttpRequestHandler.readLine(client.httpRequestMeta.inputStream, client.httpRequestMeta.charset);
        while (null != line && !line.isEmpty()) {
            logger.trace("[\u89e3\u6790Header]{}", (Object)line);
            String key = line.substring(0, line.indexOf(":"));
            String value = line.substring(key.length() + 2);
            value = new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            if (!client.httpRequestMeta.headers.containsKey(key)) {
                client.httpRequestMeta.headers.put(key, new ArrayList());
            }
            client.httpRequestMeta.headers.get(key).add(value);
            line = HttpRequestHandler.readLine(client.httpRequestMeta.inputStream, client.httpRequestMeta.charset);
        }
        if (client.httpRequestMeta.headers.containsKey("Cookie")) {
            List<String> cookieList = client.httpRequestMeta.headers.get("Cookie");
            for (String cookie : cookieList) {
                StringTokenizer st = new StringTokenizer(cookie, ";");
                while (st.hasMoreTokens()) {
                    client.httpRequestMeta.cookieList.addAll(HttpCookie.parse(st.nextToken()));
                }
            }
        }
        if (client.httpRequestMeta.headers.containsKey("Content-Length")) {
            client.httpRequestMeta.contentLength = Integer.parseInt(client.httpRequestMeta.headers.get("Content-Length").get(0));
            logger.trace("[\u63d0\u53d6ContentLength]ContentLength:{}", (Object)client.httpRequestMeta.contentLength);
        }
        if (client.httpRequestMeta.headers.containsKey("Content-Type")) {
            client.httpRequestMeta.contentType = client.httpRequestMeta.headers.get("Content-Type").get(0);
            logger.trace("[\u63d0\u53d6ContentType]ContentType:{}", (Object)client.httpRequestMeta.contentType);
        }
        Set<String> keySet = client.httpRequestMeta.headers.keySet();
        for (String key : ipHeaders) {
            if (!keySet.contains(key)) continue;
            client.httpRequestMeta.ip = client.httpRequestMeta.headers.get(key).get(0);
            if (!client.httpRequestMeta.ip.contains(",")) break;
            client.httpRequestMeta.ip = client.httpRequestMeta.ip.substring(0, client.httpRequestMeta.ip.indexOf(","));
            break;
        }
        if (null == client.httpRequestMeta.ip) {
            client.httpRequestMeta.ip = client.httpRequestMeta.remoteAddress.getHostAddress();
        }
        logger.trace("[\u63d0\u53d6ip\u5730\u5740]{}", (Object)client.httpRequestMeta.ip);
    }

    private void getCharset(HttpRequestMeta httpRequestMeta) throws IOException {
        logger.trace("[\u51c6\u5907\u63d0\u53d6\u7f16\u7801\u683c\u5f0f]");
        this.getCharsetFromContentType(httpRequestMeta);
        if (null == httpRequestMeta.charset) {
            byte[] bytes = new byte[Math.min(httpRequestMeta.inputStream.available(), 5120)];
            httpRequestMeta.inputStream.mark(bytes.length);
            httpRequestMeta.inputStream.read(bytes, 0, bytes.length);
            httpRequestMeta.inputStream.reset();
            ByteBuffer firstBytes = ByteBuffer.wrap(bytes);
            this.getCharsetFromBOM(httpRequestMeta, firstBytes);
        }
        if (null == httpRequestMeta.charset) {
            httpRequestMeta.charset = "utf-8";
            logger.trace("[\u4f7f\u7528\u9ed8\u8ba4utf-8\u7f16\u7801\u683c\u5f0f]");
        }
        logger.trace("[\u7f16\u7801\u683c\u5f0f]{}", (Object)httpRequestMeta.charset);
    }

    private void getCharsetFromBOM(HttpRequestMeta httpRequestMeta, ByteBuffer byteBuffer) {
        ByteBuffer buffer = byteBuffer;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteBuffer.remaining() >= bom.length) {
            byteBuffer.get(bom);
            ((Buffer)buffer).rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            httpRequestMeta.charset = "utf-32";
        } else if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            httpRequestMeta.charset = "utf-16";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            httpRequestMeta.charset = "utf-8";
        }
    }

    private void getCharsetFromContentType(HttpRequestMeta httpRequestMeta) {
        String prefix = "charset=";
        if (null != httpRequestMeta.contentType && httpRequestMeta.contentType.contains(prefix)) {
            int startIndex = httpRequestMeta.contentType.indexOf(prefix);
            int endIndex = httpRequestMeta.contentType.lastIndexOf(";");
            if (endIndex > startIndex) {
                httpRequestMeta.charset = httpRequestMeta.contentType.substring(startIndex + prefix.length(), endIndex).trim();
            } else if (endIndex < startIndex) {
                httpRequestMeta.charset = httpRequestMeta.contentType.substring(startIndex + prefix.length()).trim();
            }
        }
    }

    private void handleEncoding(Client client) throws IOException {
        if (client.httpRequestMeta.headers.containsKey("Transfer-Encoding") && client.httpRequestMeta.contentLength > 0L) {
            throw new IllegalArgumentException("\u5ba2\u6237\u7aef\u5934\u90e8\u540c\u65f6\u5305\u542bContent-Type\u5b57\u6bb5\u548cTransfer-Encoding,\u65e0\u6cd5\u5904\u7406!");
        }
        if (client.httpRequestMeta.headers.containsKey("Transfer-Encoding")) {
            logger.trace("[\u5ba2\u6237\u7aef\u5f00\u542f\u4e86\u5206\u5757\u4f20\u8f93]");
            client.httpRequestMeta.inputStream = new ChunkedInputStream(client.httpRequestMeta.inputStream);
        }
        if (client.httpRequestMeta.contentLength > 0L) {
            client.httpRequestMeta.inputStream = new FixedLengthInputStream(client.httpRequestMeta.inputStream, client.httpRequestMeta.contentLength);
        }
        if (client.httpRequestMeta.headers.containsKey("Content-Encoding")) {
            String contentEncoding = client.httpRequestMeta.headers.get("Content-Encoding").get(0);
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                logger.trace("[\u5ba2\u6237\u7aef\u5f00\u542f\u4e86gzip\u538b\u7f29]");
                client.httpRequestMeta.inputStream = new GZIPInputStream(client.httpRequestMeta.inputStream);
            } else if ("deflate".equalsIgnoreCase(contentEncoding)) {
                logger.trace("[\u5ba2\u6237\u7aef\u5f00\u542f\u4e86deflate\u538b\u7f29]");
                client.httpRequestMeta.inputStream = new InflaterInputStream(client.httpRequestMeta.inputStream, new Inflater(true));
            }
        }
        client.httpRequestMeta.inputStream = new BufferedInputStream(client.httpRequestMeta.inputStream);
    }

    private void handleExpect(Client client) throws IOException {
        if (client.httpRequestMeta.headers.containsKey("Expect")) {
            logger.trace("[\u5904\u7406Expect\u5934\u90e8]\u8fd4\u56de100-Continue");
            byte[] bytes = "HTTP/1.1 100 Continue\r\nContent-Length: 0\r\n\r\n".getBytes(StandardCharsets.UTF_8);
            client.httpResponseMeta.outputStream.write(bytes);
            client.httpResponseMeta.outputStream.flush();
        }
    }

    private void handleContentType(Client client) throws IOException {
        if (null == client.httpRequestMeta.contentType) {
            return;
        }
        String contentType = client.httpRequestMeta.contentType.toLowerCase();
        if (contentType.contains("application/x-www-form-urlencoded")) {
            this.getBodyAsString(client.httpRequestMeta);
            StringTokenizer st = new StringTokenizer(client.httpRequestMeta.body, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                client.httpRequestMeta.dataMap.put(token.substring(0, token.indexOf("=")), URLDecoder.decode(token.substring(token.indexOf("=") + 1), client.httpRequestMeta.charset));
            }
        } else if (contentType.contains("application/json")) {
            this.getBodyAsString(client.httpRequestMeta);
        } else if (contentType.contains("multipart/form-data")) {
            this.getMultipartData(client.httpRequestMeta);
        }
    }

    private void getBodyAsBytes(HttpRequestMeta httpRequestMeta) throws IOException {
        if (null != httpRequestMeta.bodyBytes) {
            return;
        }
        logger.trace("[\u8bfb\u53d6\u8bf7\u6c42\u4f53\u5230\u5b57\u8282\u6570\u7ec4]");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int length = 0;
        while ((length = httpRequestMeta.inputStream.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, length);
        }
        httpRequestMeta.bodyBytes = baos.toByteArray();
        logger.trace("[\u8bfb\u53d6\u8bf7\u6c42\u4f53]\u957f\u5ea6:{},\u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:{}", (Object)httpRequestMeta.contentLength, (Object)baos.size());
        baos.close();
    }

    private void getBodyAsString(HttpRequestMeta httpRequestMeta) throws IOException {
        if (null != httpRequestMeta.body && !httpRequestMeta.body.isEmpty()) {
            return;
        }
        logger.trace("[\u8bfb\u53d6\u8bf7\u6c42\u4f53\u4f5c\u4e3a\u5b57\u7b26\u4e32]");
        this.getBodyAsBytes(httpRequestMeta);
        if (null != httpRequestMeta.bodyBytes) {
            httpRequestMeta.body = new String(httpRequestMeta.bodyBytes, httpRequestMeta.charset);
        }
    }

    private void getMultipartData(HttpRequestMeta httpRequestMeta) throws IOException {
        logger.trace("[\u63d0\u53d6multipart\u5185\u5bb9]");
        httpRequestMeta.boundary = httpRequestMeta.contentType.substring(httpRequestMeta.contentType.indexOf("boundary=") + "boundary=".length());
        if (httpRequestMeta.boundary.contains(";")) {
            httpRequestMeta.boundary = httpRequestMeta.boundary.substring(0, httpRequestMeta.boundary.indexOf(";"));
        }
        byte[] boundaryBytes = ("\r\n--" + httpRequestMeta.boundary).getBytes();
        String line = HttpRequestHandler.readLine(httpRequestMeta.inputStream, httpRequestMeta.charset);
        while (line.equals("--" + httpRequestMeta.boundary)) {
            MultipartFile multipartFile = new MultipartFile();
            String contentDisposition = HttpRequestHandler.readLine(httpRequestMeta.inputStream, httpRequestMeta.charset);
            multipartFile.name = RegExpUtil.plainMatch(contentDisposition, "name=\"()\"");
            if (null == multipartFile.name) {
                multipartFile.name = RegExpUtil.plainMatch(contentDisposition, "name=();");
            }
            if (contentDisposition.contains("filename=")) {
                multipartFile.originalFilename = RegExpUtil.plainMatch(contentDisposition, "filename=\"()\"");
                if (multipartFile.originalFilename.contains(".")) {
                    multipartFile.suffixFileName = multipartFile.originalFilename.substring(multipartFile.originalFilename.lastIndexOf(".") + 1);
                }
            }
            while (!line.isEmpty()) {
                if (line.startsWith("Content-Type")) {
                    multipartFile.contentType = line.substring(line.indexOf(":") + 1).trim();
                }
                line = HttpRequestHandler.readLine(httpRequestMeta.inputStream, httpRequestMeta.charset);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int b = 0;
            byte[] bytes = new byte[boundaryBytes.length];
            while ((b = httpRequestMeta.inputStream.read()) != -1) {
                if (b == 13) {
                    httpRequestMeta.inputStream.mark(httpRequestMeta.boundary.length());
                    bytes[0] = 13;
                    httpRequestMeta.inputStream.read(bytes, 1, bytes.length - 1);
                    if (Arrays.equals(boundaryBytes, bytes)) {
                        line = "--" + httpRequestMeta.boundary;
                        break;
                    }
                    baos.write(b);
                    httpRequestMeta.inputStream.reset();
                    continue;
                }
                baos.write(b);
            }
            baos.flush();
            multipartFile.bytes = baos.toByteArray();
            if (multipartFile.originalFilename == null) {
                String value = new String(multipartFile.bytes, httpRequestMeta.charset);
                httpRequestMeta.dataMap.put(multipartFile.name, value);
            } else {
                multipartFile.size = multipartFile.bytes.length;
                multipartFile.isEmpty = multipartFile.bytes.length == 0;
                List<MultipartFile> multipartFileList = httpRequestMeta.fileParameterMap.get(multipartFile.name);
                if (null == multipartFileList) {
                    multipartFileList = new ArrayList<MultipartFile>();
                }
                multipartFileList.add(multipartFile);
                httpRequestMeta.fileParameterMap.put(multipartFile.name, multipartFileList);
            }
            if (httpRequestMeta.inputStream.read() != 45 || httpRequestMeta.inputStream.read() != 45) continue;
            break;
        }
    }
}

