/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.handler.StaticResourceHandler;
import cn.schoolwow.quickserver.interceptor.HandlerInterceptor;
import cn.schoolwow.quickserver.interceptor.Interceptor;
import cn.schoolwow.quickserver.util.AntPatternMatcher;
import java.util.Collection;

public class DispatcherHandler
implements Handler {
    @Override
    public Handler handle(Client client) throws Exception {
        Collection interceptorList = client.serverConfigMeta.applicationContext.getBeansOfType(HandlerInterceptor.class).values();
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client.httpRequestMeta.uri.getPath(), handlerInterceptor)) continue;
            handlerInterceptor.preHandle(client.httpRequest, client.httpResponse, client.httpSession);
        }
        Handler handler = new StaticResourceHandler();
        while (!(handler instanceof HttpResponseHandler)) {
            handler = handler.handle(client);
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client.httpRequestMeta.uri.getPath(), handlerInterceptor)) continue;
            handlerInterceptor.postHandle(client.httpRequest, client.httpResponse, client.httpSession);
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client.httpRequestMeta.uri.getPath(), handlerInterceptor)) continue;
            handlerInterceptor.beforeResponse(client.httpRequest, client.httpResponse, client.httpSession);
        }
        return handler;
    }

    private boolean matchInterceptor(String uri, HandlerInterceptor handlerInterceptor) {
        Interceptor interceptor = handlerInterceptor.getClass().getDeclaredAnnotation(Interceptor.class);
        if (null == interceptor) {
            return false;
        }
        for (String excludePattern : interceptor.excludePatterns()) {
            if (!AntPatternMatcher.match(uri, excludePattern)) continue;
            return false;
        }
        for (String pattern : interceptor.patterns()) {
            if (!AntPatternMatcher.match(uri, pattern)) continue;
            return true;
        }
        return false;
    }
}

