/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver;

import cn.schoolwow.quickserver.domain.ServerConfigMeta;
import cn.schoolwow.quickserver.server.HttpServer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickServer {
    private Logger logger = LoggerFactory.getLogger(QuickServer.class);
    private ServerConfigMeta serverConfigMeta = new ServerConfigMeta();

    public static QuickServer newInstance() {
        return new QuickServer();
    }

    public QuickServer port(int port) {
        this.serverConfigMeta.port = port;
        return this;
    }

    public QuickServer scan(String packageName) {
        this.serverConfigMeta.applicationContext.scan(new String[]{packageName});
        return this;
    }

    public QuickServer register(Class componentClass) {
        this.serverConfigMeta.applicationContext.register(new Class[]{componentClass});
        return this;
    }

    public QuickServer staticResourcePathPrefix(String staticResourcePathPrefix) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84\u524d\u7f00]{}", (Object)staticResourcePathPrefix);
        this.serverConfigMeta.staticResourcePathPrefix = staticResourcePathPrefix;
        return this;
    }

    public QuickServer staticResourcePath(String staticResourcePath) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84]{}", (Object)staticResourcePath);
        this.serverConfigMeta.staticResourcePathMap.put(staticResourcePath, "");
        return this;
    }

    public QuickServer staticResourcePath(String staticResourcePath, String urlPrefix) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84]\u8def\u5f84:{},url\u524d\u7f00:{}", (Object)staticResourcePath, (Object)urlPrefix);
        this.serverConfigMeta.staticResourcePathMap.put(staticResourcePath, urlPrefix);
        return this;
    }

    public QuickServer keepAlive(boolean keepAlive) {
        this.serverConfigMeta.keepAlive = keepAlive;
        return this;
    }

    public QuickServer keepAliveTimeout(int keepAliveTimeout) {
        this.serverConfigMeta.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public void start() throws IOException {
        HttpServer httpServer = new HttpServer(this.serverConfigMeta);
        httpServer.start();
    }
}

