package cn.schoolwow.quickhttp.util;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.client.CookieOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;
import cn.schoolwow.quickhttp.module.cookie.CookieOptionInvocationHandler;
import cn.schoolwow.quickhttp.module.request.HttpRequestInvocationHandler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuickHttpUtil {
    /**
     * 创建CookieOption对象动态代理对象
     * */
    public static CookieOption newCookieOptionProxy(QuickFlow quickFlow){
        CookieOptionInvocationHandler cookieOptionInvocationHandler = new CookieOptionInvocationHandler(quickFlow);
        CookieOption cookieOption = (CookieOption) java.lang.reflect.Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(),
                new Class<?>[]{CookieOption.class}, cookieOptionInvocationHandler);
        return cookieOption;
    }

    /**
     * 创建Request对象动态代理对象
     * */
    public static Request newRequestProxy(QuickFlow executeFlow){
        HttpRequestInvocationHandler httpRequestInvocationHandler = new HttpRequestInvocationHandler(executeFlow);
        Request request = (Request) java.lang.reflect.Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(),
                new Class<?>[]{Request.class}, httpRequestInvocationHandler);
        HttpRequestContext httpRequestContext = executeFlow.getContextInstanceData(HttpRequestContext.class);
        httpRequestContext.request = request;
        executeFlow.putContextTemporaryInstanceData(request, Request.class);

        HttpClientOption httpClientOption = executeFlow.getContextInstanceData(HttpClientOption.class);
        if(null!=httpClientOption.executeFlowListener){
            httpClientOption.executeFlowListener.afterCreateExecuteFlow(executeFlow);
        }
        return request;
    }


    public static String readLine(BufferedInputStream bufferedInputStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        int i = -1;
        while(true){
            i = bufferedInputStream.read();
            //\r
            if(i==0x0D){
                i = bufferedInputStream.read();
                //\n
                if(i==0x0A){
                    break;
                }else{
                    builder.append((char)i);
                }
            }else{
                builder.append((char)i);
            }
        }
        return builder.toString();
    }


    /**
     * unicode转中文
     */
    public static String unicode2Chinese(String unicodeString) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(unicodeString);
        char ch;
        while (matcher.find()) {
            ch = (char) Integer.parseInt(matcher.group(2), 16);
            unicodeString = unicodeString.replace(matcher.group(1), ch + "");
        }
        return unicodeString;
    }
}
