package cn.schoolwow.quickhttp.module.webSocket.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketStream;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketStreamImpl;
import cn.schoolwow.quickhttp.util.WebSocketUtil;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class WriteWebSocketFrameFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketStream webSocketStream = flowContext.checkInstanceData(WebSocketStream.class);
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);

        try (WebSocketStream writeSocketStream = new WebSocketStreamImpl();){
            int[] bits = new int[8];
            bits[0] = webSocketFrame.fin?1:0;
            WebSocketUtil.setBitValue(bits,4,7,webSocketFrame.opCode.value);
            writeSocketStream.writeBit(bits);
            flowContext.log("第1个字节:{}", Arrays.toString(bits));

            bits = new int[8];
            bits[0] = webSocketFrame.mask?1:0;
            flowContext.log("负载实际长度:{}", webSocketFrame.payloadLength);
            if(webSocketFrame.payloadLength<126){
                WebSocketUtil.setBitValue(bits,1,7,(int) webSocketFrame.payloadLength);
                writeSocketStream.writeBit(bits);
            }else if(webSocketFrame.payloadLength<Short.MAX_VALUE){
                WebSocketUtil.setBitValue(bits,1,7,126);
                writeSocketStream.writeBit(bits);
                writeSocketStream.writeShort((int) webSocketFrame.payloadLength);
                flowContext.log("负载长度占用字节:2字节");
            }else {
                WebSocketUtil.setBitValue(bits,1,7, 127);
                writeSocketStream.writeBit(bits);
                writeSocketStream.writeLong(webSocketFrame.payloadLength);
                flowContext.log("负载长度占用字节:8字节");
            }
            if(webSocketFrame.mask){
                flowContext.log("掩码key:{}", Arrays.toString(webSocketFrame.maskKey));
                writeSocketStream.write(webSocketFrame.maskKey);
                if(OPCode.Close.equals(webSocketFrame.opCode)){
                    flowContext.log("写入关闭帧");
                }else if(null!=webSocketFrame.payload){
                    flowContext.log("写入负载");
                    flowContext.log("负载文本:{}", new String(webSocketFrame.payload,StandardCharsets.UTF_8));
                    flowContext.log("负载十六进制:{}", WebSocketUtil.byteArrayToHex(webSocketFrame.payload));
                }
                if(webSocketFrame.payloadLength>0&&null!=webSocketFrame.payload){
                    WebSocketUtil.mask(webSocketFrame.payload, webSocketFrame.maskKey);
                }
            }
            if(null!=webSocketFrame.payload){
                writeSocketStream.write(webSocketFrame.payload);
            }
            webSocketStream.write(writeSocketStream.toByteArray());
            webSocketStream.flush();
            //还原数据
            if(webSocketFrame.mask&&webSocketFrame.payloadLength>0&&null!=webSocketFrame.payload){
                WebSocketUtil.mask(webSocketFrame.payload, webSocketFrame.maskKey);
            }
        }
    }

    @Override
    public String name() {
        return "写入WebSocket帧服务流程";
    }
}
