package cn.schoolwow.quickhttp.module.webSocket.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.module.webSocket.flow.common.CheckMaskFlow;
import cn.schoolwow.quickhttp.module.webSocket.flow.common.CheckWebSocketFrameFlow;
import cn.schoolwow.quickhttp.module.webSocket.flow.frame.GetCompleteFrameFlow;

public class SendWebSocketPingFrameServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketFrame pingWebSocketFrame = WebSocketFrame.newInstance()
                .opCode(OPCode.PingFrame)
                .mask(true);

        flowContext.putTemporaryInstanceData(pingWebSocketFrame);

        flowContext.executeFlowList(
                new WriteWebSocketFrameFlow(),
                new GetCompleteFrameFlow(),
                new CheckMaskFlow(),
                new CheckWebSocketFrameFlow()
        );
    }

    @Override
    public String name() {
        return "发送WebSocket的Ping帧服务流程";
    }
}
