package cn.schoolwow.quickhttp.module.webSocket.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;

import java.nio.charset.StandardCharsets;

public class ReceiveWebSocketTextServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new ReceiveWebSocketBinaryServiceFlow());

        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);
        String text = new String(webSocketFrame.payload, StandardCharsets.UTF_8);
        flowContext.putData("text", text);
    }

    @Override
    public String name() {
        return "接收WebSocket文本数据帧";
    }
}
