package cn.schoolwow.quickhttp.module.webSocket.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketState;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketStream;

public class CloseWebSocketStreamServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketFrame webSocketFrame = WebSocketFrame.newInstance()
                .opCode(OPCode.Close)
                .mask(true);
        flowContext.startFlow(new WriteWebSocketFrameFlow())
                .putTemporaryInstanceData(webSocketFrame)
                .execute();
        flowContext.putContextTemporaryInstanceData(WebSocketState.Closing);
        WebSocketStream webSocketStream = flowContext.checkInstanceData(WebSocketStream.class);
        webSocketStream.close();
        flowContext.putContextTemporaryInstanceData(WebSocketState.Closed);
    }

    @Override
    public String name() {
        return "关闭WebSocket流服务流程";
    }
}
