package cn.schoolwow.quickhttp.module.webSocket.flow.frame;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.module.webSocket.service.WriteWebSocketFrameFlow;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class WriteCompleteFrameFlow implements BusinessFlow {
    /**分段大小,默认为1MB*/
    private static final int FRAGMENT_SIZE = 1024*1024;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);
        Object writeLock = flowContext.checkData("writeLock");

        synchronized (writeLock){
            //判断负载大小,超时指定大小则分段发送
            if(null==webSocketFrame.payload||webSocketFrame.payload.length<FRAGMENT_SIZE){
                flowContext.executeFlowList(new WriteWebSocketFrameFlow());
                return;
            }
            sendByMultipleFrame(flowContext);
        }
    }

    @Override
    public String name() {
        return "写入WebSocket完整帧";
    }

    private void sendByMultipleFrame(FlowContext flowContext) throws IOException {
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);

        ByteArrayInputStream baos = new ByteArrayInputStream(webSocketFrame.payload);
        //分段数组
        byte[] fragmentBytes = new byte[FRAGMENT_SIZE];
        //记录已发送帧大小
        int total = 0;
        //发送起始帧
        int length = baos.read(fragmentBytes,0,fragmentBytes.length);
        {
            WebSocketFrame startWebSocketFrame = WebSocketFrame.newInstance()
                    .fin(false)
                    .opCode(webSocketFrame.opCode)
                    .mask(webSocketFrame.mask)
                    .payload(fragmentBytes);
            total += length;
            flowContext.log("起始帧:0-{}",total);
            flowContext.startFlow(new WriteWebSocketFrameFlow())
                    .putCurrentCompositeFlowInstanceData(startWebSocketFrame)
                    .execute();
        }
        //发送持续帧
        {
            while((length = baos.read(fragmentBytes,0,fragmentBytes.length))==fragmentBytes.length){
                WebSocketFrame continueWebSocketFrame = WebSocketFrame.newInstance()
                        .fin(false)
                        .opCode(OPCode.ContinueFrame)
                        .mask(webSocketFrame.mask)
                        .payload(fragmentBytes);
                flowContext.log("持续帧:{}-{}",total,total+length);
                total += length;
                flowContext.startFlow(new WriteWebSocketFrameFlow())
                        .putCurrentCompositeFlowInstanceData(continueWebSocketFrame)
                        .execute();
            }
        }

        //发送结尾帧
        {
            byte[] endFragmentBytes = new byte[length];
            System.arraycopy(fragmentBytes, 0, endFragmentBytes, 0, endFragmentBytes.length);
            WebSocketFrame endWebSocketFrame = WebSocketFrame.newInstance()
                    .fin(true)
                    .opCode(OPCode.ContinueFrame)
                    .mask(webSocketFrame.mask)
                    .payload(endFragmentBytes);
            flowContext.log("结尾帧:{}-{}",total,total+length);
            flowContext.startFlow(new WriteWebSocketFrameFlow())
                    .putCurrentCompositeFlowInstanceData(endWebSocketFrame)
                    .execute();
        }
        baos.close();
    }
}
