package cn.schoolwow.quickhttp.module.webSocket.flow.frame;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.CloseCode;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketStream;
import cn.schoolwow.quickhttp.util.WebSocketUtil;

import java.io.IOException;
import java.util.Arrays;

public class GetWebSocketFrameFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketStream webSocketStream = flowContext.checkInstanceData(WebSocketStream.class);

        WebSocketFrame webSocketFrame = new WebSocketFrame();
        int[] bits = webSocketStream.readBitByte();
        //是否终止
        webSocketFrame.fin = bits[0]==1;
        //操作码
        webSocketFrame.opCode = OPCode.getOPCode(WebSocketUtil.getBitValue(bits,4,7));
        flowContext.log("第1个字节:{}", Arrays.toString(bits));

        bits = webSocketStream.readBitByte();
        //是否开启掩码
        webSocketFrame.mask = bits[0]==1;
        //负载长度
        webSocketFrame.payloadLength = WebSocketUtil.getBitValue(bits,1,7);
        flowContext.log("负载长度占用位数:{}", webSocketFrame.payloadLength);
        if(webSocketFrame.payloadLength==126){
            flowContext.log("负载长度占用字节:2字节");
            webSocketFrame.payloadLength = webSocketStream.readShort();
        }else if(webSocketFrame.payloadLength==127){
            flowContext.log("负载长度占用字节:8字节");
            webSocketFrame.payloadLength = webSocketStream.readLong();
        }
        flowContext.log("负载实际长度:{}", webSocketFrame.payloadLength);
        if(webSocketFrame.mask){
            flowContext.log("读取掩码key");
            webSocketFrame.maskKey = new byte[4];
            int length = webSocketStream.read(webSocketFrame.maskKey,0,webSocketFrame.maskKey.length);
            flowContext.log("掩码key:{}", Arrays.toString(webSocketFrame.maskKey));
            if(length!=webSocketFrame.maskKey.length){
                throw new IOException("读取掩码失败!预期字节长度:4,实际长度:"+length);
            }
        }
        webSocketFrame.payload = new byte[(int) webSocketFrame.payloadLength];
        webSocketStream.read(webSocketFrame.payload, 0, webSocketFrame.payload.length);
        if(webSocketFrame.mask&&webSocketFrame.payloadLength>0){
            flowContext.log("服务端进行反掩码操作");
            WebSocketUtil.mask(webSocketFrame.payload, webSocketFrame.maskKey);
        }
        if(OPCode.Close.equals(webSocketFrame.opCode)){
            webSocketFrame.closeCode = CloseCode.getCloseCodeByCode(webSocketFrame.payload);
        }
        flowContext.putTemporaryInstanceData(webSocketFrame);
    }

    @Override
    public String name() {
        return "读取WebSocket一帧流程";
    }
}
