package cn.schoolwow.quickhttp.module.webSocket.flow.frame;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;

public class GetCompleteFrameFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new GetWebSocketFrameFlow());

        Object readLock = flowContext.checkData("readLock");
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);

        int times = 0;
        synchronized (readLock){
            boolean fin = webSocketFrame.fin;
            while(!fin&&times<100){
                WebSocketFrame nextFrame = flowContext.checkInstanceData(WebSocketFrame.class);
                byte[] data = new byte[nextFrame.payload.length+nextFrame.payload.length];
                System.arraycopy(webSocketFrame.payload, 0, data, 0, webSocketFrame.payload.length);
                System.arraycopy(nextFrame.payload, 0, data, webSocketFrame.payload.length, nextFrame.payload.length);
                webSocketFrame.payload = data;
                fin = nextFrame.fin;
                times++;
            }
        }
        if(times>=100){
            flowContext.broken("帧数据异常!超过100帧还未结束!");
        }
        flowContext.putTemporaryInstanceData(webSocketFrame);
    }

    @Override
    public String name() {
        return "读取WebSocket完整帧流程";
    }
}
