package cn.schoolwow.quickhttp.module.webSocket.flow.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketState;
import cn.schoolwow.quickhttp.util.WebSocketUtil;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class CheckWebSocketFrameFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);
        OPCode expectCode = flowContext.checkData("expectCode", OPCode.class);

        if(expectCode.equals(webSocketFrame.opCode)){
            return;
        }
        if(OPCode.Close.equals(webSocketFrame.opCode)){
            String description = new String(webSocketFrame.payload,2,webSocketFrame.payload.length-2, StandardCharsets.UTF_8);
            flowContext.log("非预期帧内容:{}", description);
            flowContext.putContextTemporaryInstanceData(WebSocketState.Closed);
        }else{
            flowContext.log("非预期帧内容:{}", new String(webSocketFrame.payload,StandardCharsets.UTF_8));
            flowContext.log("非预期帧十六进制内容:{}", WebSocketUtil.byteArrayToHex(webSocketFrame.payload));
        }
        throw new IOException("接收到非预期数据帧!期望帧类型:"+expectCode+",当前帧类型:"+webSocketFrame.opCode);
    }

    @Override
    public String name() {
        return "检查WebSocket数据帧";
    }
}
