package cn.schoolwow.quickhttp.module.webSocket.flow.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.websocket.CloseCode;
import cn.schoolwow.quickhttp.domain.websocket.OPCode;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketFrame;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketMode;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketStream;
import cn.schoolwow.quickhttp.module.webSocket.flow.frame.WriteCompleteFrameFlow;

import java.io.IOException;

public class CheckMaskFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WebSocketStream webSocketStream = flowContext.checkInstanceData(WebSocketStream.class);
        WebSocketFrame webSocketFrame = flowContext.checkInstanceData(WebSocketFrame.class);
        WebSocketMode webSocketMode = flowContext.checkInstanceData(WebSocketMode.class);

        boolean shouldWrite = false;
        String message = null;
        switch (webSocketMode){
            case Client:{
                shouldWrite = !webSocketFrame.mask;
                message = "客户端数据帧未设置掩码";
            }break;
            case Server:{
                shouldWrite = webSocketFrame.mask;
                message = "服务端数据帧设置了掩码";
            }break;
            default:{
                throw new IllegalArgumentException("不支持的模式!模式:"+webSocketMode.name());
            }
        }
        if(shouldWrite){
            WebSocketFrame closeWebSocketFrame = WebSocketFrame.newInstance()
                    .opCode(OPCode.Close)
                    .closeCode(CloseCode.PROTOCOL_ERROR)
                    .mask(true);
            flowContext.startFlow(new WriteCompleteFrameFlow())
                    .putTemporaryData("closeWebSocketFrame", closeWebSocketFrame)
                    .execute();
            webSocketStream.close();
            throw new IOException(message);
        }
    }

    @Override
    public String name() {
        return "检查数据帧掩码";
    }
}
