package cn.schoolwow.quickhttp.module.webSocket.domain;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.TreeMap;

public interface WebSocketStream extends DataInput, DataOutput, Closeable, AutoCloseable {
    /**
     * 读取一个字节
     * */
    int read() throws IOException;

    /**
     * 读取指定长度的字节数组
     * */
    int read(byte b[]) throws IOException;

    /**
     * 读取指定长度和偏移的字节数组
     * */
    int read(byte b[], int off, int len) throws IOException;

    /**
     * 读取指定字节长度数组
     * */
    byte[] readByteArray(int length) throws IOException;

    /**
     * 读取标准头部信息
     * */
    TreeMap<String, List<String>> readHeaders() throws IOException;

    /**
     * 读取一个字节
     * */
    int[] readBitByte() throws IOException;

    /**
     * 读取指定字节
     * */
    int[] readBitByte(int nByte) throws IOException;

    /**
     * 写入一行
     * */
    void writeLine(String line) throws IOException;

    /**
     * 写入比特位字节
     * */
    void writeBit(int[] bits) throws IOException;

    /**
     * 刷新缓冲区
     * */
    void flush() throws IOException;

    /**
     * 已写入大小
     * */
    int size();

    /**
     * 转换成字节数组
     * */
    byte[] toByteArray();

    /**
     * 关闭流
     * */
    void close();

    /**
     * 返回套接字
     * */
    Socket getSocket();
}