package cn.schoolwow.quickhttp.module.response.parse;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.response.body.kit.ResponseBody;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.io.IOException;

public class ResponseParseImpl implements ResponseParse{
    private ResponseBody responseBody;
    private HttpResponseContext httpResponseContext;

    public ResponseParseImpl(ResponseBody responseBody, QuickFlow quickFlow) {
        this.responseBody = responseBody;
        this.httpResponseContext = quickFlow.getContextInstanceData(HttpResponseContext.class);
    }
    
    @Override
    public Document parse() throws IOException {
        if (httpResponseContext.document == null) {
            if (httpResponseContext.body == null) {
                responseBody.body();
            }
            httpResponseContext.document = Jsoup.parse(responseBody.body());
        }
        return httpResponseContext.document;
    }

}
