package cn.schoolwow.quickhttp.module.response.header.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class GetFileNameHeaderServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        String contentDisposition = httpResponseContext.headerMap.containsKey("Content-Disposition")?httpResponseContext.headerMap.get("Content-Disposition").get(0):null;
        if (null == contentDisposition) {
            return;
        }
        String fileName = null;
        if (contentDisposition.contains("filename*=")) {
            fileName = contentDisposition.substring(contentDisposition.indexOf("filename*=") + "filename*=".length());
            String charset = fileName.substring(0, fileName.indexOf("''")).replace("\"", "");
            fileName = fileName.substring(fileName.indexOf("''") + 2).replace("\"", "");
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), Charset.forName(charset));
            try {
                fileName = URLDecoder.decode(fileName,charset);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (contentDisposition.contains("filename=")) {
            fileName = contentDisposition.substring(contentDisposition.indexOf("filename=") + "filename=".length());
            fileName = fileName.replace("\"", "").trim();
        }
        flowContext.putData("fileName", fileName);
    }

    @Override
    public String name() {
        return "根据头部解析文件名称服务流程";
    }
}
