package cn.schoolwow.quickhttp.module.response.header.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickhttp.module.response.HttpResponseParent;
import cn.schoolwow.quickhttp.module.response.header.service.GetFileNameHeaderServiceFlow;

import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

public class ResponseHeaderImpl extends HttpResponseParent implements ResponseHeader{

    public ResponseHeaderImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }

    @Override
    public String url() {
        return httpRequestOption.url.toString();
    }

    @Override
    public int statusCode() {
        return httpResponseContext.statusCode;
    }

    @Override
    public String statusMessage() {
        return httpResponseContext.statusMessage;
    }

    @Override
    public String charset() {
        return httpResponseContext.charset;
    }

    @Override
    public String contentType() {
        return httpResponseContext.contentType;
    }

    @Override
    public long contentLength() {
        return httpResponseContext.contentLength;
    }

    @Override
    public String filename() {
        FlowContext flowContext = quickFlow.startFlow(new GetFileNameHeaderServiceFlow()).execute();
        String fileName = flowContext.getData("fileName", String.class);
        return fileName;
    }

    @Override
    public boolean acceptRanges() {
        return hasHeader("Accept-Ranges", "bytes");
    }

    @Override
    public String contentEncoding() {
        List<String> values = header("Content-Encoding");
        return null==values?null:values.get(0);
    }

    @Override
    public boolean hasHeader(String name) {
        return httpResponseContext.headerMap.containsKey(name);
    }

    @Override
    public boolean hasHeader(String name, String value) {
        return hasHeader(name) && httpResponseContext.headerMap.get(name).get(0).equals(value);
    }

    @Override
    public List<String> header(String name) {
        return httpResponseContext.headerMap.get(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return httpResponseContext.headerMap;
    }

    @Override
    public boolean hasCookie(String name) {
        return httpClientOption.cookieOption.hasCookie(httpRequestOption.url.getHost(),name);
    }

    @Override
    public boolean hasCookie(String name, String value) {
        HttpCookie httpCookie = httpClientOption.cookieOption.getCookie(httpRequestOption.url.getHost(),name);
        return null!=httpCookie&&httpCookie.getValue().equals(value);
    }

    @Override
    public HttpCookie getCookie(String name) {
        for(HttpCookie httpCookie:httpResponseContext.httpCookieList){
            if(httpCookie.getName().equals(name)){
                return httpCookie;
            }
        }
        return null;
    }

    @Override
    public List<HttpCookie> getCookieList() {
        return httpResponseContext.httpCookieList;
    }
}
