package cn.schoolwow.quickhttp.module.response.header.kit;

import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

/**响应头部*/
public interface ResponseHeader {
    /**
     * 获取返回地址
     */
    String url();

    /**
     * 获取状态码
     */
    int statusCode();

    /**
     * 获取状态说明
     */
    String statusMessage();

    /**
     * 获取编码格式
     */
    String charset();

    /**
     * 获取返回格式类型
     */
    String contentType();

    /**
     * 获取大小
     */
    long contentLength();

    /**
     * 获取文件名
     */
    String filename();

    /**
     * 是否支持分段下载
     */
    boolean acceptRanges();

    /**
     * 获取contentEncoding头部信息,若不存在则返回null
     */
    String contentEncoding();

    /**
     * 是否有该Header
     * @param name 头部名称
     */
    boolean hasHeader(String name);

    /**
     * 是否存在该Header
     * @param name 头部名称
     * @param value 头部值
     */
    boolean hasHeader(String name, String value);

    /**
     * 获取头部信息
     * @param name 头部名称
     */
    List<String> header(String name);

    /**
     * 获取所有Header信息
     */
    Map<String, List<String>> headers();

    /**
     * 是否存在指定Cookie
     * @param name cookie名称
     * */
    boolean hasCookie(String name);

    /**
     * 是否存在指定Cookie
     * @param name cookie名称
     * @param value cookie值
     * */
    boolean hasCookie(String name, String value);

    /**
     * 获取本次请求返回指定Cookie
     * */
    HttpCookie getCookie(String name);

    /**
     * 本次请求返回Cookie
     * */
    List<HttpCookie> getCookieList();
}
