package cn.schoolwow.quickhttp.module.response.body.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Set;

public class HttpResponseBodyAsFileServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkBodyExist(flowContext);
        copyToFile(flowContext);
    }

    @Override
    public String name() {
        return "响应体转为文件服务流程";
    }

    private void checkBodyExist(FlowContext flowContext) throws Exception{
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
        Path file = flowContext.checkData("file", Path.class);

        if (null==httpResponseContext.inputStream) {
            throw new IOException("写入文件失败!输入流为空!url:" + httpRequestOption.url.toString());
        }

        if (!file.getParent().toFile().exists()) {
            file.getParent().toFile().mkdirs();
        }

        if (null != httpResponseContext.body) {
            if (file.toFile().exists()) {
                Files.write(file, httpResponseContext.body, StandardOpenOption.APPEND);
            } else {
                Files.write(file, httpResponseContext.body, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
            flowContext.brokenCurrentFlow("响应内容已获取过，直接写入文件");
        }
    }

    private void copyToFile(FlowContext flowContext) throws Exception{
        Path file = flowContext.checkData("file", Path.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        int retryTimes = 1;
        IOException e = null;
        long contentLength = httpResponseContext.contentLength;
        //处理超时异常,尝试重试
        while (retryTimes <= httpRequestOption.retryTimes) {
            try {
                if (null != httpResponseContext.contentEncoding || contentLength == -1) {
                    Files.deleteIfExists(file);
                    byte[] buffer = new byte[8192];
                    int length = 0;
                    try (FileOutputStream fos = new FileOutputStream(file.toFile());){
                        while((length=httpResponseContext.inputStream.read(buffer,0,buffer.length))>=0){
                            fos.write(buffer,0,length);
                            if(Thread.currentThread().isInterrupted()){
                                flowContext.log("线程中断,文件下载任务停止!");
                                break;
                            }
                        }
                        fos.flush();
                    }
                } else {
                    Set<StandardOpenOption> openOptions = null;
                    if (file.toFile().exists()) {
                        openOptions = EnumSet.of(StandardOpenOption.APPEND);
                    } else {
                        openOptions = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                    }
                    try (ReadableByteChannel readableByteChannel = Channels.newChannel(httpResponseContext.inputStream);
                         FileChannel fileChannel = FileChannel.open(file, openOptions);){
                        fileChannel.transferFrom(readableByteChannel, Files.size(file), contentLength);
                    }catch (ClosedByInterruptException ex){
                        flowContext.log("线程中断,文件下载任务停止!");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                break;
            } catch (SocketTimeoutException | ConnectException ex) {
                e = ex;
                flowContext.log("下载超时,重试{}/{},链接:{}", retryTimes, httpRequestOption.retryTimes, httpRequestOption.url.toString());
                retryTimes++;
            }
        }
        flowContext.executeFlowList(new CloseHttpResponseServiceFlow());
        if(retryTimes>httpRequestOption.retryTimes&&null!=e){
            throw e;
        }
    }
}
