package cn.schoolwow.quickhttp.module.response.body.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class HttpResponseBodyAsByteServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        if(null==httpResponseContext.inputStream){
            throw new IOException("http请求响应输入流获取失败!");
        }
        Path tempFilePath = Files.createTempFile("QuickHttp4.",".response");
        Files.copy(httpResponseContext.inputStream,tempFilePath, StandardCopyOption.REPLACE_EXISTING);
        httpResponseContext.body = Files.readAllBytes(tempFilePath);
        Files.deleteIfExists(tempFilePath);
        flowContext.executeFlowList(new CloseHttpResponseServiceFlow());
    }

    @Override
    public String name() {
        return "响应体转为字节数组服务流程";
    }
}
